/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.ProcedureWithExpRowMapper;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureTypeDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcedureDAO
extends AbstractDAO
implements IProcedureDAO {
    public static final String TABLES_JOIN_WITH_EXP = String.format("from %s si join %s p on p.id = si.proc_id join %s pcty on pcty.id = p.pcty_id join %s e on e.id = p.expe_id join %s as proj on e.proj_id = proj.id ", "sample_inputs", "procedures", "procedure_types", "experiments", "projects");
    static final String SELECT = "select p.*, pcty.code as pcty_code, pcty.description as pcty_description, pcty.is_data_acquisition as pcty_is_data_acquisition ";
    public static final String SELECT_WITH_EXP = "select p.*, pcty.code as pcty_code, pcty.description as pcty_description, pcty.is_data_acquisition as pcty_is_data_acquisition , e.code as e_code, e.inva_id as e_inva_id, proj.code as proj_code, proj.grou_id as proj_grou_id ";
    static final String FROM = String.format("from %s as p, %s as pcty ", "procedures", "procedure_types");
    public static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ProcedureDAO.class);
    static final ParameterizedRowMapper<ProcedureDTO> PROCEDURE_ROW_MAPPER = new ParameterizedRowMapper<ProcedureDTO>(){

        public final ProcedureDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            ProcedureDTO procedure = new ProcedureDTO(rs.getLong("expe_id"));
            procedure.setId(rs.getLong("id"));
            procedure.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            ProcedureTypeDTO type = new ProcedureTypeDTO();
            type.setId(rs.getLong("pcty_id"));
            type.setCode(CodeConverter.tryToBusinessLayer(rs.getString("pcty_code")));
            type.setDescription(rs.getString("pcty_description"));
            type.setDataAcquisition(rs.getBoolean("pcty_is_data_acquisition"));
            procedure.setProcedureType(type);
            return procedure;
        }
    };
    public static final ParameterizedRowMapper<ProcedureDTO> PROCEDURE_ROW_MAPPER_WITH_EXP = new ProcedureWithExpRowMapper();
    private final ISequenceNameMapper sequenceNameMapper;

    ProcedureDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.sequenceNameMapper = sequenceNameMapper;
    }

    private final long createId() {
        return this.getNextValueOf(this.sequenceNameMapper.getSequencerForTable("procedures"));
    }

    @Override
    public final List<ProcedureDTO> listSampleInputProcedures() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query(SELECT_WITH_EXP + TABLES_JOIN_WITH_EXP, PROCEDURE_ROW_MAPPER_WITH_EXP, new Object[0]);
        TableMap<Long, ProcedureDTO> map = new TableMap<Long, ProcedureDTO>(list, KeyExtractorFactory.getProcedureByIdKeyExtractor(), TableMap.UniqueKeyViolationStrategy.KEEP_FIRST);
        ArrayList<ProcedureDTO> returned = new ArrayList<ProcedureDTO>(map.values());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d unique procedure(s) connected to at least one sample has(have) been found.", returned.size()));
        }
        return returned;
    }

    @Override
    public final List<ProcedureDTO> listProceduresWithExp(long sampleId, long groupId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query(SELECT_WITH_EXP + TABLES_JOIN_WITH_EXP + "where samp_id = ? and proj.grou_id = ?", PROCEDURE_ROW_MAPPER_WITH_EXP, new Object[]{sampleId, groupId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d procedure(s) has(have) been found for sample id %d and group id %d", list.size(), sampleId, groupId));
        }
        return list;
    }

    @Override
    public final void createProcedure(ProcedureDTO procedure) throws DataAccessException {
        assert (procedure != null) : "Given procedure can not be null.";
        Long experimentID = procedure.getExperimentID();
        assert (experimentID != null) : "Experiment id can not be null.";
        assert (procedure.getProcedureType() != null) : "Procedure type can not be null.";
        long id = this.createId();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into procedures (id, expe_id, pcty_id) values (?,?,?)", new Object[]{id, experimentID, procedure.getProcedureType().getId()});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("A new procedure '" + procedure + "' has been inserted for experiment id '" + experimentID + "'.");
        }
        procedure.setId(id);
    }

    @Override
    public final List<ProcedureDTO> listProcedures(long experimentID) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.query(SELECT + FROM + "where p.expe_id = ? and p.pcty_id = pcty.id", PROCEDURE_ROW_MAPPER, new Object[]{experimentID});
    }

    @Override
    public final ProcedureDTO getProcedure(long procedureID) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query(SELECT + FROM + "where p.id = ? and p.pcty_id = pcty.id", PROCEDURE_ROW_MAPPER, new Object[]{procedureID});
        this.checkSizeIsOne(list, "procedure", procedureID);
        return (ProcedureDTO)list.get(0);
    }

    @Override
    public final ProcedureDTO tryGetProcedure(String procedureTypeCode, long experimentID) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query(SELECT + FROM + "where p.expe_id = ? " + "and p.pcty_id = pcty.id and pcty.code = ?", PROCEDURE_ROW_MAPPER, new Object[]{experimentID, procedureTypeCode});
        if (list.size() > 1) {
            throw new DataRetrievalFailureException("Expected zero or one entries, got " + list.size());
        }
        if (list.isEmpty()) {
            return null;
        }
        return (ProcedureDTO)list.get(0);
    }
}

