/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.ProcedureDAO;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcedureWithExpRowMapper
implements ParameterizedRowMapper<ProcedureDTO> {
    ProcedureWithExpRowMapper() {
    }

    public final ProcedureDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
        ProcedureDTO procedure = (ProcedureDTO)ProcedureDAO.PROCEDURE_ROW_MAPPER.mapRow(rs, rowNum);
        BaseExperimentDTO experiment = new BaseExperimentDTO(null);
        experiment.setId(procedure.getExperimentID());
        experiment.setCode(CodeConverter.tryToBusinessLayer(rs.getString("e_code")));
        long invalidationId = rs.getLong("e_inva_id");
        if (!rs.wasNull()) {
            experiment.setInvalidationId(invalidationId);
        }
        ProjectDTO project = new ProjectDTO(rs.getLong("proj_grou_id"));
        project.setCode(CodeConverter.tryToBusinessLayer(rs.getString("proj_code")));
        experiment.setProject(project);
        procedure.setExperiment(experiment);
        return procedure;
    }
}

