/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.IDataSetService;
import ch.systemsx.cisd.lims.server.business.DomainModel;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.webclient.server.LoggerUtils;

public class DataSetService
implements IDataSetService {
    private final ISessionManager sessionManager;
    private final DomainModel domainModel;

    public DataSetService(ISessionManager sessionManager, DomainModel domainModel) {
        this.sessionManager = sessionManager;
        this.domainModel = domainModel;
    }

    public ExternalData getDataSet(String sessionToken, String dataSetCode) throws UserFailureException {
        boolean operationSuccessful = false;
        Session session = this.getSession(sessionToken);
        try {
            ISampleManager sampleManager = this.domainModel.getSampleManager();
            ExternalDataDTO data = sampleManager.getDataSet(session, dataSetCode);
            ExternalData result = BeanUtils.createBean(ExternalData.class, data);
            operationSuccessful = true;
            ExternalData externalData = result;
            return externalData;
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).getDataSet(dataSetCode));
        }
    }

    private Session getSession(String sessionToken) {
        Session session = this.sessionManager.getSession(sessionToken);
        if (session == null) {
            throw new EnvironmentFailureException("Invalid session ID: " + sessionToken);
        }
        return session;
    }

    public String authenticate(String user, String password) throws UserFailureException {
        throw new UnsupportedOperationException();
    }

    public Void closeSession(String sessionToken) throws UserFailureException {
        throw new UnsupportedOperationException();
    }

    public int getVersion() {
        return 18;
    }
}

