/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class UrlServletForwardingController
extends AbstractController {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, UrlServletForwardingController.class);

    private final String getServletName(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String servletName = this.getServletName(request);
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher(servletName);
        if (rd == null) {
            throw new ServletException(String.format("No servlet with name '%s' defined in web.xml", servletName));
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Forwarded to servlet [%s] in '%s'.", servletName, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        return null;
    }
}

