/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LoggingContextHandler;
import ch.systemsx.cisd.common.utilities.ClassUtils;
import ch.systemsx.cisd.lims.base.IWebService;
import ch.systemsx.cisd.lims.base.LogMessageProvider;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.base.server.RequestContextProviderAdapter;
import ch.systemsx.cisd.lims.server.business.DomainModel;
import ch.systemsx.cisd.lims.server.business.IPersonManager;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dataaccess.IGroupDAO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import ch.systemsx.cisd.lims.webservice.IAccessController;
import org.apache.log4j.Logger;
import org.springframework.dao.EmptyResultDataAccessException;

abstract class AbstractLIMSService
implements IWebService {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractLIMSService.class);
    private final ISessionManager sessionManager;
    private final IAccessController accessController;
    private final LoggingContextHandler loggingContextHandler;
    protected final DomainModel domainModel;
    private final String groupCode;

    AbstractLIMSService(ISessionManager sessionManager, IRequestContextProvider requestContextProvider, IAccessController accessController, DomainModel domainModel, String groupCode) {
        assert (sessionManager != null) : "Undefined session manager.";
        this.sessionManager = sessionManager;
        assert (requestContextProvider != null) : "Undefined IRequestContextProvider.";
        this.loggingContextHandler = new LoggingContextHandler(new RequestContextProviderAdapter(requestContextProvider));
        assert (accessController != null) : "Undefined access controller";
        this.accessController = accessController;
        assert (domainModel != null) : "Undefined domain model";
        this.domainModel = domainModel;
        if (operationLog.isInfoEnabled()) {
            operationLog.info("A new instance of '" + this.getClass().getSimpleName() + "' has been created.");
        }
        this.groupCode = groupCode;
    }

    protected final void checkAccess(String sessionToken) {
        this.loggingContextHandler.setMDC(sessionToken);
        String methodToCheck = ClassUtils.getMethodOnStack(2).getName();
        Session session = this.getSession(sessionToken);
        if (!this.accessController.isAuthorized(session, methodToCheck)) {
            String msg = "User '" + session.getUserName() + "' has " + "insufficient privileges to call method '" + methodToCheck + "'.";
            operationLog.warn(msg);
            throw new UserFailureException("Insufficient privileges to call this command.");
        }
    }

    protected final Session getSession(String sessionToken) {
        try {
            return this.sessionManager.getSession(sessionToken);
        }
        catch (UserFailureException ex) {
            this.loggingContextHandler.destroyContext(sessionToken);
            throw ex;
        }
    }

    private final void ensureUserRegistered(Session session) {
        IPersonManager personManager = this.domainModel.getPersonManager();
        PersonDTO person = personManager.getPerson(session);
        if (person == null) {
            personManager.registerPerson(session);
        }
    }

    public int getVersion() {
        return 18;
    }

    public String authenticate(String user, String password) {
        try {
            IGroupDAO dao = this.domainModel.getDAOFactory().getGroupDAO();
            String sessionToken = this.sessionManager.openSession(user, password, dao.getGroupById(dao.getGroupIdByCode(this.groupCode)));
            if (sessionToken != null) {
                Session session = this.sessionManager.getSession(sessionToken);
                this.loggingContextHandler.addContext(session.getSessionToken(), session.toString());
                this.ensureUserRegistered(session);
            }
            return sessionToken;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            throw UserFailureException.fromTemplate("Given group code '%s' could not be found in the database.", this.groupCode);
        }
    }

    public Void closeSession(String sessionToken) {
        this.sessionManager.closeSession(sessionToken);
        this.loggingContextHandler.destroyContext(sessionToken);
        return null;
    }

    protected long extractSessionStart(String sessionToken) {
        return this.getSession(sessionToken).getSessionStart();
    }

    private void logUserBehaviour(LogCategory category, String message) {
        Logger logger = LogFactory.getLogger(category);
        logger.info(message);
    }

    protected LogMessageProvider createLogger(String username, String group, boolean invocationSuccessful) {
        return new LogMessageProvider(username, group, invocationSuccessful);
    }

    protected LogMessageProvider createLogger(Session session, boolean invocationSuccessful) {
        String sessionToken = null;
        if (session != null) {
            sessionToken = session.getSessionToken();
        }
        return this.createLogger(sessionToken, invocationSuccessful);
    }

    protected LogMessageProvider createLogger(String sessionToken, boolean invocationSuccessful) {
        String username = null;
        String group = null;
        Session session = this.getSession(sessionToken);
        if (session != null) {
            username = session.getUserName();
            group = session.getGroupCode();
        }
        return this.createLogger(username, group, invocationSuccessful);
    }

    protected void logAccessUserBehaviour(String message) {
        this.logUserBehaviour(LogCategory.ACCESS, message);
    }

    protected void logTrackingUserBehaviour(String message) {
        this.logUserBehaviour(LogCategory.TRACKING, message);
    }

    protected void logAuthUserBehaviour(String message) {
        this.logUserBehaviour(LogCategory.AUTH, message);
    }
}

