/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.FromStringIdentityConverter;
import ch.systemsx.cisd.common.collections.IFromStringConverter;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import ch.systemsx.cisd.common.collections.ToStringDefaultConverter;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionIO {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, FileUtilities.class);

    public static boolean readCollectionFromResource(String resource, Collection<String> collection) {
        return CollectionIO.readCollectionFromResource(resource, collection, FromStringIdentityConverter.getInstance());
    }

    public static <T> boolean readCollectionFromResource(String resource, Collection<T> collection, IFromStringConverter<T> converter) {
        InputStream resourceStream = FileUtilities.class.getResourceAsStream(resource);
        if (resourceStream == null) {
            machineLog.error((Object)String.format("Resource '%s' not found.", resource));
            return false;
        }
        return CollectionIO.readCollection(resourceStream, collection, converter, String.format("<resource '%s'>", resource));
    }

    public static boolean readCollection(File file, Collection<String> collection) {
        return CollectionIO.readCollection(file, collection, FromStringIdentityConverter.getInstance());
    }

    public static <T> boolean readCollection(File file, Collection<T> collection, IFromStringConverter<T> converter) {
        try {
            return CollectionIO.readCollection(new FileInputStream(file), collection, converter, String.format("<file '%s'>", file.getPath()));
        }
        catch (FileNotFoundException e) {
            machineLog.error((Object)String.format("File '%s' is not accessible.", file.getPath()), (Throwable)e);
            return false;
        }
    }

    public static boolean readCollection(InputStream istream, Collection<String> collection) {
        return CollectionIO.readCollection(istream, collection, FromStringIdentityConverter.getInstance());
    }

    public static <T> boolean readCollection(InputStream istream, Collection<T> collection, IFromStringConverter<T> converter) {
        return CollectionIO.readCollection(istream, collection, converter, null);
    }

    public static <T> boolean readCollection(InputStream istream, Collection<T> collection, IFromStringConverter<T> converter, String id) {
        assert (istream != null);
        assert (converter != null);
        assert (collection != null);
        BufferedReader bufferedReader = null;
        try {
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(istream));
                while ((line = bufferedReader.readLine()) != null) {
                    collection.add(converter.fromString(line));
                }
            }
            catch (IOException e) {
                block23: {
                    if (id != null) {
                        machineLog.error((Object)String.format("Error when reading from %s.", id), (Throwable)e);
                    } else {
                        machineLog.error((Object)"Error when reading from reader.", (Throwable)e);
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e2) {
                            if (id != null) {
                                machineLog.warn((Object)String.format("Error when closing reader of %s.", id), (Throwable)e2);
                                break block23;
                            }
                            machineLog.warn((Object)"Error when closing reader.", (Throwable)e2);
                        }
                    }
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            block24: {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        if (id != null) {
                            machineLog.warn((Object)String.format("Error when closing reader of %s.", id), (Throwable)e);
                            break block24;
                        }
                        machineLog.warn((Object)"Error when closing reader.", (Throwable)e);
                    }
                }
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                if (id != null) {
                    machineLog.warn((Object)String.format("Error when closing reader of %s.", id), (Throwable)e);
                }
                machineLog.warn((Object)"Error when closing reader.", (Throwable)e);
            }
        }
        return true;
    }

    public static List<String> readListFromResource(String resource) {
        return CollectionIO.readListFromResource(resource, FromStringIdentityConverter.getInstance());
    }

    public static <T> List<T> readListFromResource(String resource, IFromStringConverter<T> converter) {
        assert (resource != null);
        assert (converter != null);
        ArrayList result = new ArrayList();
        if (CollectionIO.readCollectionFromResource(resource, result, converter)) {
            return result;
        }
        return null;
    }

    public static Set<String> readSetFromResource(String resource) {
        return CollectionIO.readSetFromResource(resource, FromStringIdentityConverter.getInstance());
    }

    public static <T> Set<T> readSetFromResource(String resource, IFromStringConverter<T> converter) {
        assert (resource != null);
        assert (converter != null);
        HashSet result = new HashSet();
        if (CollectionIO.readCollectionFromResource(resource, result, converter)) {
            return result;
        }
        return null;
    }

    public static List<String> readList(File file) {
        return CollectionIO.readList(file, FromStringIdentityConverter.getInstance());
    }

    public static <T> List<T> readList(File file, IFromStringConverter<T> converter) {
        assert (file != null);
        assert (converter != null);
        ArrayList result = new ArrayList();
        if (CollectionIO.readCollection(file, result, converter)) {
            return result;
        }
        return null;
    }

    public static Set<String> readSet(File file) {
        return CollectionIO.readSet(file, FromStringIdentityConverter.getInstance());
    }

    public static <T> Set<T> readSet(File file, IFromStringConverter<T> converter) {
        assert (file != null);
        assert (converter != null);
        HashSet result = new HashSet();
        if (CollectionIO.readCollection(file, result, converter)) {
            return result;
        }
        return null;
    }

    public static <T> boolean writeIterable(File file, Iterable<T> iterable) {
        return CollectionIO.writeIterable(file, iterable, ToStringDefaultConverter.getInstance());
    }

    /*
     * Loose catch block
     */
    public static <T> boolean writeIterable(File file, Iterable<T> iterable, IToStringConverter<? super T> converter) {
        boolean bl;
        FileOutputStream fos;
        block11: {
            fos = null;
            fos = new FileOutputStream(file);
            bl = CollectionIO.writeIterable(fos, iterable, converter);
            if (fos == null) break block11;
            try {
                fos.close();
            }
            catch (IOException ex) {
                machineLog.error((Object)String.format("Error closing file '%s'.", file.getPath()), (Throwable)ex);
                return false;
            }
        }
        return bl;
        catch (FileNotFoundException e) {
            block12: {
                try {
                    machineLog.error((Object)String.format("File '%s' is not accessible.", file.getPath()), (Throwable)e);
                    if (fos == null) break block12;
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ex) {
                            machineLog.error((Object)String.format("Error closing file '%s'.", file.getPath()), (Throwable)ex);
                            return false;
                        }
                    }
                    throw throwable;
                }
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    machineLog.error((Object)String.format("Error closing file '%s'.", file.getPath()), (Throwable)ex);
                    return false;
                }
            }
            return false;
        }
    }

    public static <T> boolean writeIterable(OutputStream ostream, Iterable<T> iterable) {
        return CollectionIO.writeIterable(ostream, iterable, ToStringDefaultConverter.getInstance());
    }

    public static <T> boolean writeIterable(OutputStream ostream, Iterable<T> iterable, IToStringConverter<? super T> converter) {
        assert (ostream != null);
        return CollectionIO.writeIterable(new PrintStream(ostream), iterable, converter);
    }

    public static <T> boolean writeIterable(PrintStream printStream, Iterable<T> iterable, IToStringConverter<? super T> converter) {
        assert (printStream != null);
        assert (iterable != null);
        assert (converter != null);
        for (T entry : iterable) {
            printStream.println(converter.toString(entry));
        }
        return !printStream.checkError();
    }

    public static <T> boolean writeIterable(PrintStream printStream, Iterable<T> iterable) {
        return CollectionIO.writeIterable(printStream, iterable, ToStringDefaultConverter.getInstance());
    }

    public static final <T> boolean writeIterable(Writer writer, Iterable<T> iterable, IToStringConverter<? super T> converter) {
        assert (writer != null) : "Given Writer can not be null.";
        return CollectionIO.writeIterable(new PrintWriter(writer), iterable, converter);
    }

    public static final <T> boolean writeIterable(PrintWriter writer, Iterable<T> iterable, IToStringConverter<? super T> converterOrNull) {
        assert (writer != null) : "Given PrintWriter can not be null";
        assert (iterable != null) : "Given Iterable can not be null";
        IToStringConverter<Object> converter = converterOrNull == null ? ToStringDefaultConverter.getInstance() : converterOrNull;
        for (T entry : iterable) {
            writer.println(converter.toString(entry));
        }
        return !writer.checkError();
    }
}

