/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.tiff;

import ch.systemsx.cisd.common.compression.file.InPlaceCompressionMethod;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.io.File;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiffZipCompressionMethod
extends InPlaceCompressionMethod {
    static final File convertExecutable = OSUtilities.findExecutable("convert");

    private static String getImageMagickVersion(String convertExecutableToCheck) {
        ProcessResult result = ProcessExecutionHelper.run(Arrays.asList(convertExecutableToCheck, "--version"), operationLog, machineLog, 2000L);
        result.log();
        String versionString = TiffZipCompressionMethod.extractImageMagickVersion(result.getOutput().get(0));
        return versionString;
    }

    private static String extractImageMagickVersion(String imageMagickVersionLine) {
        if (!imageMagickVersionLine.startsWith("Version: ImageMagick")) {
            return null;
        }
        String[] versionStringParts = imageMagickVersionLine.split("\\s+");
        if (versionStringParts.length < 3) {
            return null;
        }
        return versionStringParts[2];
    }

    @Override
    protected List<String> createCommandLine(File fileToCompress, File inProgressFile) {
        assert (convertExecutable != null);
        assert (fileToCompress != null);
        assert (fileToCompress.isFile());
        assert (inProgressFile != null);
        assert (!inProgressFile.exists());
        List<String> parameters = Arrays.asList(convertExecutable.getAbsolutePath(), fileToCompress.getAbsolutePath(), "-compress", "Zip", inProgressFile.getAbsolutePath());
        return parameters;
    }

    @Override
    protected List<String> getAcceptedExtensions() {
        return Arrays.asList(".tif", ".tiff");
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        if (convertExecutable == null) {
            throw new ConfigurationFailureException("Cannot find executable of the convert utility.");
        }
        String imageMagickVersionOrNull = TiffZipCompressionMethod.getImageMagickVersion(convertExecutable.getAbsolutePath());
        if (imageMagickVersionOrNull == null) {
            throw new ConfigurationFailureException("Invalid convert utility");
        }
        String[] imageMagickVersionParts = imageMagickVersionOrNull.split("\\.");
        if (imageMagickVersionParts.length != 3) {
            throw new ConfigurationFailureException("Invalid convert utility");
        }
        int imageMagickMajorVersion = Integer.parseInt(imageMagickVersionParts[0]);
        int imageMagickMinorVersion = Integer.parseInt(imageMagickVersionParts[1]);
        if (imageMagickMajorVersion < 6 || imageMagickMinorVersion < 2) {
            throw ConfigurationFailureException.fromTemplate("Convert utility is too old (expected: v6.2 or newer, found: v%s)", imageMagickVersionOrNull);
        }
        if (machineLog.isInfoEnabled()) {
            machineLog.info((Object)String.format("Using convert executable '%s', ImageMagick version %s", convertExecutable, imageMagickVersionOrNull));
        }
    }

    public static void main(String[] args) {
        LogInitializer.init();
        TiffZipCompressionMethod compressor = new TiffZipCompressionMethod();
        compressor.check();
    }
}

