/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.ByteArrayOutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;

public final class BufferedAppender
extends WriterAppender {
    private final ByteArrayOutputStream logRecorder = new ByteArrayOutputStream();

    public BufferedAppender() {
        this(Level.DEBUG);
    }

    public BufferedAppender(Level logLevel) {
        this(null, logLevel);
    }

    public BufferedAppender(String pattern, Level logLevel) {
        this.setWriter(this.createWriter(this.logRecorder));
        this.setLayout(this.createLayout(pattern));
        this.configureRootLogger();
        this.setThreshold((Priority)logLevel);
    }

    private final void configureRootLogger() {
        Logger.getRootLogger().addAppender((Appender)this);
    }

    protected Layout createLayout(String pattern) {
        return new PatternLayout(pattern);
    }

    public final String getLogContent() {
        return new String(this.logRecorder.toByteArray()).trim();
    }

    public final void resetLogContent() {
        this.logRecorder.reset();
    }

    public final void reset() {
        Logger.getRootLogger().removeAppender((Appender)this);
        super.reset();
    }

    public final String toString() {
        return this.getEncoding();
    }
}

