/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;

public class LogInitializer {
    private static final String LOG_DIRECTORY = "etc";
    private static final String LOG_FILENAME = "log.xml";
    private static boolean initialized;

    static {
        System.setProperty("log4j.defaultInitOverride", "true");
        initialized = false;
    }

    private static final URL createURL() {
        return LogInitializer.class.getResource("/etc/log.xml");
    }

    private static final File createLogFile() {
        return new File(LOG_DIRECTORY, LOG_FILENAME);
    }

    private static final void configureFromFile(File logFile) {
        assert (logFile != null && logFile.exists()) : "Given log file must be not null and must exist.";
        DOMConfigurator.configureAndWatch((String)logFile.getPath());
        LogLog.debug((String)String.format("Log configured from file '%s' (watching).", logFile.getAbsolutePath()));
    }

    private static final void configureFromURL(URL url) {
        assert (url != null) : "Given url can not be null.";
        try {
            File logFile = new File(url.toURI());
            if (logFile.exists()) {
                LogInitializer.configureFromFile(logFile);
                return;
            }
        }
        catch (URISyntaxException ex) {
            LogLog.warn((String)String.format("Given url '%s' could not be parsed.", url), (Throwable)ex);
        }
        DOMConfigurator.configure((URL)url);
        LogLog.debug((String)String.format("Log configured from URL '%s' (NOT watching).", url));
    }

    public static final synchronized void init() {
        if (initialized) {
            return;
        }
        File logFile = LogInitializer.createLogFile();
        if (logFile.exists()) {
            LogInitializer.configureFromFile(logFile);
        } else {
            URL url = LogInitializer.createURL();
            if (url != null) {
                LogInitializer.configureFromURL(url);
            } else {
                BasicConfigurator.configure();
            }
        }
        initialized = true;
        LogLog.setQuietMode((boolean)true);
    }
}

