/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessResult {
    public static final int EXIT_VALUE_OK = 0;
    public static final int NO_EXIT_VALUE = -1;
    private static final int EXIT_VALUE_FOR_TERMINATION_WINDOWS = 1;
    private static final int EXIT_VALUE_FOR_TERMINATION_UNIX = 143;
    private final ExecutionStatus status;
    private final String startupFailureMessage;
    private final int exitValue;
    private final List<String> commandLine;
    private final String commandName;
    private final int processNumber;
    private final Logger operationLog;
    private final Logger machineLog;
    private final boolean outputAvailable;
    private final List<String> output;

    public static boolean isProcessTerminated(int exitValue) {
        if (OSUtilities.isWindows()) {
            return exitValue == 1;
        }
        return exitValue == 143;
    }

    public static boolean isProcessOK(int exitValue) {
        return exitValue == 0;
    }

    ProcessResult(List<String> commandLine, int processNumber, ExecutionStatus status, String startupFailureMessageOrNull, int exitValue, List<String> processOutputOrNull, Logger operationLog, Logger machineLog) {
        this.commandLine = commandLine;
        this.commandName = ProcessExecutionHelper.getCommandName(commandLine);
        this.processNumber = processNumber;
        this.status = status;
        this.startupFailureMessage = startupFailureMessageOrNull == null ? "" : startupFailureMessageOrNull;
        this.exitValue = exitValue;
        this.outputAvailable = processOutputOrNull != null;
        this.output = this.outputAvailable ? Collections.unmodifiableList(processOutputOrNull) : Collections.emptyList();
        this.operationLog = operationLog;
        this.machineLog = machineLog;
    }

    public List<String> getCommandLine() {
        return this.commandLine;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public int getProcessNumber() {
        return this.processNumber;
    }

    public boolean isOutputAvailable() {
        return this.outputAvailable;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getStartupFailureMessage() {
        return this.startupFailureMessage;
    }

    public boolean isOK() {
        return ProcessResult.isProcessOK(this.exitValue);
    }

    public boolean isRun() {
        return StringUtils.isBlank((String)this.startupFailureMessage);
    }

    public boolean isTerminated() {
        return ProcessResult.isProcessTerminated(this.getExitValue());
    }

    public boolean isTimedOut() {
        return ExecutionStatus.TIMED_OUT.equals((Object)this.status);
    }

    public boolean isInterruped() {
        return ExecutionStatus.INTERRUPTED.equals((Object)this.status);
    }

    public void log() {
        if (!this.isOK()) {
            this.logProcessExitValue(Level.WARN);
            this.logProcessOutput(Level.WARN);
        } else if (this.operationLog.isDebugEnabled()) {
            this.logProcessExitValue(Level.DEBUG);
            this.logProcessOutput(Level.DEBUG);
        }
    }

    private void logProcessExitValue(Level logLevel) {
        if (!this.isRun()) {
            this.operationLog.log((Priority)logLevel, (Object)String.format("P%d-{%s} process has not started up: '%s'.", this.processNumber, this.commandName, this.startupFailureMessage));
        } else if (this.isTimedOut()) {
            this.operationLog.log((Priority)logLevel, (Object)String.format("P%d-{%s} process has timed out.", this.processNumber, this.commandName));
        } else if (this.isInterruped()) {
            this.operationLog.log((Priority)logLevel, (Object)String.format("P%d-{%s} thread was interrupted.", this.processNumber, this.commandName));
        } else if (this.isTerminated()) {
            this.operationLog.log((Priority)logLevel, (Object)String.format("P%d-{%s} process was terminated.", this.processNumber, this.commandName));
        } else {
            this.operationLog.log((Priority)logLevel, (Object)String.format("P%d-{%s} process returned with exit value %d.", this.processNumber, this.commandName, this.getExitValue()));
        }
    }

    private void logProcessOutput(Level logLevel) {
        assert (logLevel != null);
        List<String> processOutputLines = this.getOutput();
        if (processOutputLines.size() == 0) {
            return;
        }
        this.machineLog.log((Priority)logLevel, (Object)String.format("[%s] output:", this.commandName));
        for (String ln : processOutputLines) {
            if (ln.trim().length() <= 0) continue;
            this.machineLog.log((Priority)logLevel, (Object)String.format("\"%s\"", ln));
        }
    }
}

