/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class PathPrefixPrepender {
    private final String prefixForAbsolutePaths;
    private final String prefixForRelativePaths;

    public PathPrefixPrepender(String prefixForAbsolutePathsOrNull, String prefixForRelativePathsOrNull) throws ConfigurationFailureException {
        this.prefixForAbsolutePaths = StringUtils.defaultString((String)prefixForAbsolutePathsOrNull);
        this.assertValid(this.prefixForAbsolutePaths, "absolute");
        this.prefixForRelativePaths = PathPrefixPrepender.preparePrefix(prefixForRelativePathsOrNull);
        this.assertValid(this.prefixForRelativePaths, "relative");
    }

    private static final String preparePrefix(String pathPrefix) {
        if (StringUtils.isEmpty((String)pathPrefix)) {
            return "";
        }
        if (pathPrefix.endsWith("/")) {
            return pathPrefix;
        }
        return String.valueOf(pathPrefix) + "/";
    }

    private void assertValid(String prefix, String type) throws ConfigurationFailureException {
        File file;
        if (prefix.length() != 0 && !(file = new File(prefix)).exists()) {
            throw ConfigurationFailureException.fromTemplate("Invalid prefix for %s paths: given file '%s' does not exist.", type, file.getAbsolutePath());
        }
    }

    public String addPrefixTo(String path) {
        assert (path != null) : "Undefined path.";
        return String.valueOf(FilenameUtils.getPrefixLength((String)path) > 0 ? this.prefixForAbsolutePaths : this.prefixForRelativePaths) + path;
    }
}

