/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FileFilter {
    private final Set<PathPattern> pathPatternSet = new HashSet<PathPattern>();

    public RegexFileFilter() {
    }

    public RegexFileFilter(PathType type, String regex) {
        this.add(type, regex);
    }

    public void add(PathType type, String regexPattern) {
        assert (regexPattern != null);
        this.add(type, Pattern.compile(regexPattern));
    }

    public void add(PathType type, Pattern regex) {
        assert (type != null);
        assert (regex != null);
        this.pathPatternSet.add(new PathPattern(type, regex));
    }

    public boolean accept(File pathname) {
        for (PathPattern pattern : this.pathPatternSet) {
            if (!pattern.matches(pathname)) continue;
            return true;
        }
        return false;
    }

    private static class PathPattern {
        private final PathType type;
        private final Pattern pattern;

        PathPattern(PathType type, Pattern pattern) {
            assert (type != null);
            assert (pattern != null);
            this.type = type;
            this.pattern = pattern;
        }

        boolean matches(File file) {
            return this.matchesType(file) && this.pattern.matcher(file.getName()).matches();
        }

        private boolean matchesType(File file) {
            if (PathType.ALL.equals((Object)this.type)) {
                return true;
            }
            if (PathType.FILE.equals((Object)this.type) && file.isFile()) {
                return true;
            }
            return PathType.DIRECTORY.equals((Object)this.type) && file.isDirectory();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PathPattern)) {
                return false;
            }
            PathPattern that = (PathPattern)obj;
            return this.type.equals((Object)that.type) && this.pattern.pattern().equals(that.pattern.pattern());
        }

        public int hashCode() {
            return (1003 + this.type.hashCode()) * 59 + this.pattern.pattern().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        FILE,
        DIRECTORY,
        ALL;

    }
}

