/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ITriggerable;
import ch.systemsx.cisd.common.utilities.SynchronizationMonitor;
import java.io.File;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class TriggeringTimerTask
extends TimerTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, TriggeringTimerTask.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, TriggeringTimerTask.class);
    private final ITriggerable triggerable;
    private final File triggerFile;
    private final SynchronizationMonitor monitor;

    public TriggeringTimerTask(File triggerFile, ITriggerable triggerable) {
        this(triggerFile, triggerable, SynchronizationMonitor.create());
    }

    public TriggeringTimerTask(File triggerFile, ITriggerable triggerable, SynchronizationMonitor monitor) {
        assert (triggerFile != null);
        assert (triggerable != null);
        assert (monitor != null);
        this.triggerFile = triggerFile;
        this.triggerable = triggerable;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        SynchronizationMonitor synchronizationMonitor = this.monitor;
        synchronized (synchronizationMonitor) {
            try {
                if (this.triggerFile.exists()) {
                    this.trigger();
                    this.triggerFile.delete();
                }
            }
            catch (Exception ex) {
                notificationLog.error((Object)"An exception has occurred. (thread still running)", (Throwable)ex);
            }
        }
    }

    private void trigger() {
        if (this.triggerable != null) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("File '%s' found - triggering.", this.triggerFile.getAbsolutePath()));
            }
            this.triggerable.trigger();
        }
    }
}

