/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.IDataSetService;
import ch.systemsx.cisd.lims.base.ILIMSServiceFactory;
import ch.systemsx.cisd.lims.base.ServiceRegistry;
import ch.systemsx.cisd.openbis.datasetdownload.ConfigParameters;

class DataSetService
implements IDataSetService {
    private IDataSetService service;

    DataSetService(ConfigParameters configParameters) {
        ILIMSServiceFactory factory = ServiceRegistry.getLIMSServiceFactory();
        this.service = factory.createDataSetService(configParameters.getServerURL());
    }

    public ExternalData getDataSet(String sessionToken, String dataSetCode) throws UserFailureException {
        return this.service.getDataSet(sessionToken, dataSetCode);
    }

    public String authenticate(String user, String password) throws UserFailureException {
        return this.service.authenticate(user, password);
    }

    public Void closeSession(String sessionToken) throws UserFailureException {
        return this.service.closeSession(sessionToken);
    }

    public int getVersion() {
        return this.service.getVersion();
    }
}

