/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.openbis.datasetdownload.HTMLDirectoryRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IErrorRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IRendererFactory;
import ch.systemsx.cisd.openbis.datasetdownload.RenderingContext;
import java.io.PrintWriter;

public class HTMLRendererFactory
implements IRendererFactory {
    public String getContentType() {
        return "text/html";
    }

    public IDirectoryRenderer createDirectoryRenderer(RenderingContext context) {
        return new HTMLDirectoryRenderer(context);
    }

    public IErrorRenderer createErrorRenderer() {
        return new HTMLErrorRenderer();
    }

    private static class HTMLErrorRenderer
    implements IErrorRenderer {
        private PrintWriter writer;

        private HTMLErrorRenderer() {
        }

        public void setWriter(PrintWriter writer) {
            this.writer = writer;
        }

        public void printErrorMessage(String errorMessage) {
            this.writer.println("<html><body><h1>Error</h1>");
            this.writer.println(errorMessage);
            this.writer.println("</body></html>");
        }
    }
}

