/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.File;

final class RenderingContext {
    private final File rootDir;
    private final String relativePathOrNull;
    private File file;
    private final String urlPrefix;
    private String relativeParentPath;

    RenderingContext(File rootDir, String urlPrefix, String relativePathOrNull) {
        this.rootDir = rootDir;
        this.relativePathOrNull = relativePathOrNull;
        this.file = rootDir;
        this.urlPrefix = urlPrefix;
        if (relativePathOrNull != null && relativePathOrNull.length() > 0) {
            this.file = new File(rootDir, relativePathOrNull);
            this.relativeParentPath = FileUtilities.getRelativeFile(rootDir, this.file.getParentFile());
            if (this.relativeParentPath == null) {
                this.relativeParentPath = "";
            }
        }
    }

    public final File getRootDir() {
        return this.rootDir;
    }

    public final String getRelativePathOrNull() {
        return this.relativePathOrNull;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getUrlPrefix() {
        return this.urlPrefix;
    }

    public final String getRelativeParentPath() {
        return this.relativeParentPath;
    }
}

