/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.FormatStore;
import ch.systemsx.cisd.bds.IFormatParameterFactory;
import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.INode;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Format
implements IStorable {
    static final String FOLDER = "format";
    static final String CODE = "code";
    static final String VARIANT = "variant";
    private final String code;
    private final Version version;
    private final String variant;

    static final Format loadFrom(IDirectory directory) {
        Format format;
        INode dir = directory.tryGetNode(FOLDER);
        if (!(dir instanceof IDirectory)) {
            throw new DataStructureException("Not a directory: " + dir);
        }
        IDirectory formatDir = (IDirectory)dir;
        INode file = formatDir.tryGetNode(CODE);
        if (!(file instanceof IFile)) {
            throw new DataStructureException("Not a plain file: " + file);
        }
        IFile codeFile = (IFile)file;
        String formatCode = codeFile.getStringContent().trim();
        Version formatVersion = Version.loadFrom(formatDir);
        String variant = null;
        file = formatDir.tryGetNode(VARIANT);
        if (file != null) {
            if (!(file instanceof IFile)) {
                throw new DataStructureException("Not a plain file: " + file);
            }
            variant = ((IFile)file).getStringContent().trim();
        }
        if ((format = FormatStore.getFormat(formatCode, formatVersion, variant)) == null) {
            format = new Format(formatCode, formatVersion, variant);
        }
        return format;
    }

    public static final Format tryToCreateFormatFromString(String value) {
        return Format.tryToCreateFormatFromString(value, false);
    }

    static Format tryToCreateFormatFromString(String value, boolean createIfWellFormed) {
        Version version;
        assert (value != null) : "Format string is not expected to be null.";
        int index = value.lastIndexOf(86);
        if (index > -1 && (version = Version.createVersionFromString(value.substring(index + 1))) != null) {
            Format format;
            String firstPart = value.substring(0, index).trim();
            String variant = null;
            if (firstPart.endsWith("]") && (index = firstPart.indexOf(91)) > -1) {
                variant = firstPart.substring(index + 1, firstPart.length() - 1);
                firstPart = firstPart.substring(0, index).trim();
            }
            if ((format = FormatStore.getFormat(firstPart, version, variant)) == null && createIfWellFormed) {
                format = new Format(firstPart, version, variant);
            }
            return format;
        }
        return null;
    }

    public Format(String code, Version version, String variantOrNull) {
        assert (code != null) : "Unspecified format code.";
        assert (version != null) : "Unpsecified version.";
        this.code = code;
        this.version = version;
        this.variant = variantOrNull;
    }

    public final String getCode() {
        return this.code;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final String getVariant() {
        return this.variant;
    }

    public IFormatParameterFactory getFormatParameterFactory() {
        return IFormatParameterFactory.DEFAULT_FORMAT_PARAMETER_FACTORY;
    }

    public List<String> getParameterNames() {
        return Collections.emptyList();
    }

    @Override
    public final void saveTo(IDirectory directory) {
        IDirectory dir = directory.makeDirectory(FOLDER);
        dir.addKeyValuePair(CODE, this.code);
        this.version.saveTo(dir);
        if (this.variant != null) {
            dir.addKeyValuePair(VARIANT, this.variant);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Format)) {
            return false;
        }
        Format format = (Format)obj;
        return format.code.equals(this.code) && format.version.equals(this.version) && (format.variant == null ? this.variant == null : format.variant.equals(this.variant));
    }

    public int hashCode() {
        return (this.code.hashCode() * 37 + this.version.hashCode()) * 37 + (this.variant == null ? 0 : this.variant.hashCode());
    }

    public String toString() {
        return "Format: " + this.code + " " + this.version + (this.variant == null ? "" : " [" + this.variant + "]");
    }
}

