/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.storage.IDirectory;

public class Geometry
implements IStorable {
    private static final String X = "x";
    static final String NOT_POSITIVE = "Given geometry component '%s' must be > 0 (%d <= 0).";
    static final String ROWS = "rows";
    static final String COLUMNS = "columns";
    private final int rows;
    private final int columns;

    Geometry(int rows, int columns) {
        assert (columns > 0) : String.format("Given geometry component '%s' must be > 0 (%d <= 0).", "columns", columns);
        this.columns = columns;
        assert (rows > 0) : String.format("Given geometry component '%s' must be > 0 (%d <= 0).", "rows", rows);
        this.rows = rows;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    private final String toString(int number) {
        return Integer.toString(number);
    }

    static Geometry createFromString(String toString) {
        assert (toString != null) : "Given string can not be null.";
        int index = toString.indexOf(X);
        if (index > -1) {
            try {
                int rows = Integer.parseInt(toString.substring(0, index));
                int columns = Integer.parseInt(toString.substring(index + X.length()));
                return new Geometry(rows, columns);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    static final Geometry loadFrom(IDirectory directory, String geometryDirectoryName) {
        assert (directory != null) : "Given directory can not be null.";
        assert (directory.getName().startsWith(geometryDirectoryName)) : "Given directory name must start with given '" + geometryDirectoryName + "'.";
        return new Geometry(Utilities.getNumber(directory, ROWS), Utilities.getNumber(directory, COLUMNS));
    }

    public final void saveTo(IDirectory directory) {
        assert (directory != null) : "Given directory can not be null.";
        IDirectory geometryDirectory = directory.makeDirectory(this.getGeometryDirectoryName());
        geometryDirectory.addKeyValuePair(ROWS, this.toString(this.getRows()));
        geometryDirectory.addKeyValuePair(COLUMNS, this.toString(this.getColumns()));
    }

    public final boolean contains(Location location) {
        assert (location != null) : "Given location can not be null.";
        return location.getX() <= this.getColumns() && location.getY() <= this.getRows();
    }

    protected String getGeometryDirectoryName() {
        throw new UnsupportedOperationException();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry geometry = (Geometry)obj;
        return geometry.rows == this.rows && geometry.columns == this.columns;
    }

    public final int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 37 + this.getRows();
        hashCode = hashCode * 37 + this.getColumns();
        return hashCode;
    }

    public final String toString() {
        return String.valueOf(this.getRows()) + X + this.getColumns();
    }
}

