/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.AbstractFormattedData;
import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.FormattedDataContext;
import ch.systemsx.cisd.bds.IFormatParameters;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.exception.StorageException;
import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.HCSImageFormatV1_0;
import ch.systemsx.cisd.bds.hcs.IHCSImageFormattedData;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.INode;
import java.io.File;
import java.util.HashSet;

public final class HCSImageFormattedData
extends AbstractFormattedData
implements IHCSImageFormattedData {
    public static final String COLUMN = "column";
    public static final String ROW = "row";

    public HCSImageFormattedData(FormattedDataContext context) {
        super(context);
    }

    public final boolean containsOriginalData() {
        return ((Utilities.Boolean)((Object)this.getFormatParameters().getValue("contains_original_data"))).toBoolean();
    }

    public final Geometry getWellGeometry() {
        return (Geometry)this.getFormatParameters().getValue("well_geometry");
    }

    public final Geometry getPlateGeometry() {
        return (Geometry)this.getFormatParameters().getValue("plate_geometry");
    }

    public final int getChannelCount() {
        return (Integer)this.getFormatParameters().getValue("number_of_channels");
    }

    private static final void checkLocation(Geometry geometry, Location location) {
        if (!geometry.contains(location)) {
            throw new IllegalArgumentException(String.format("Given geometry '%s' does not contain location '%s'", geometry, location));
        }
    }

    private final void checkChannel(int channel) {
        if (channel < 1) {
            throw new IndexOutOfBoundsException(String.format("Channel index must start at 1 (given value is %d).", channel));
        }
        int channelCount = this.getChannelCount();
        if (channel > channelCount) {
            throw new IndexOutOfBoundsException(String.format("Channel index %d exceeds the number of channels %d", channel, channelCount));
        }
    }

    static final String createWellFileName(Location wellLocation) {
        assert (wellLocation != null) : "Well location can not be null.";
        return ROW + wellLocation.getY() + "_" + COLUMN + wellLocation.getX() + ".tiff";
    }

    private final IDirectory getStandardDataDirectory() throws DataStructureException {
        return Utilities.getSubDirectory(this.dataDirectory, "standard");
    }

    private final IDirectory getOriginalDataDirectory() throws DataStructureException {
        return Utilities.getSubDirectory(this.dataDirectory, "original");
    }

    private static final String getPlateColumnDir(Location plateLocation) {
        return COLUMN + plateLocation.getX();
    }

    private static final String getPlateRowDirName(Location plateLocation) {
        return ROW + plateLocation.getY();
    }

    private static final String getChannelName(int channel) {
        return "channel" + channel;
    }

    private void checkCoordinates(int channel, Location plateLocation, Location wellLocation) {
        this.checkChannel(channel);
        assert (plateLocation != null) : "Plate location can not be null.";
        assert (wellLocation != null) : "Well location can not be null.";
        HCSImageFormattedData.checkLocation(this.getPlateGeometry(), plateLocation);
        HCSImageFormattedData.checkLocation(this.getWellGeometry(), wellLocation);
    }

    private final IDirectory getImageRootDirectoryNode(File imageRootDirectory) {
        INode imageRootNode;
        String imageRootDirName;
        IDirectory originalDataDirectory = this.getOriginalDataDirectory();
        if (originalDataDirectory.tryGetNode(imageRootDirName = imageRootDirectory.getName()) == null) {
            originalDataDirectory.addFile(imageRootDirectory, null, true);
        }
        if ((imageRootNode = originalDataDirectory.tryGetNode(imageRootDirName)) == null) {
            throw new DataStructureException(String.format("No image root directory named '%s' could be found in the original directory.", imageRootDirName));
        }
        assert (imageRootNode instanceof IDirectory) : "Image root node must be a directory.";
        return (IDirectory)imageRootNode;
    }

    public final INode tryGetStandardNodeAt(int channel, Location wellLocation, Location tileLocation) {
        this.checkCoordinates(channel, wellLocation, tileLocation);
        try {
            IDirectory standardDir = this.getStandardDataDirectory();
            IDirectory channelDir = Utilities.getSubDirectory(standardDir, HCSImageFormattedData.getChannelName(channel));
            IDirectory plateRowDir = Utilities.getSubDirectory(channelDir, HCSImageFormattedData.getPlateRowDirName(wellLocation));
            IDirectory plateColumnDir = Utilities.getSubDirectory(plateRowDir, HCSImageFormattedData.getPlateColumnDir(wellLocation));
            return plateColumnDir.tryGetNode(HCSImageFormattedData.createWellFileName(tileLocation));
        }
        catch (DataStructureException dataStructureException) {
            return null;
        }
    }

    public final IHCSImageFormattedData.NodePath addStandardNode(File imageRootDirectory, String imageRelativePath, int channel, Location wellLocation, Location tileLocation) throws DataStructureException {
        assert (imageRootDirectory != null) : "Given image root directory can not be null.";
        assert (imageRelativePath != null) : "Given image relative path can not be null.";
        INode node = this.tryGetStandardNodeAt(channel, wellLocation, tileLocation);
        if (node != null) {
            throw new DataStructureException(String.format("A node already exists at channel %d, plate location '%s' and well location '%s'.", channel, wellLocation, tileLocation));
        }
        IDirectory standardDir = this.getStandardDataDirectory();
        IDirectory channelDir = Utilities.getOrCreateSubDirectory(standardDir, HCSImageFormattedData.getChannelName(channel));
        IDirectory plateRowDir = Utilities.getOrCreateSubDirectory(channelDir, HCSImageFormattedData.getPlateRowDirName(wellLocation));
        IDirectory plateColumnDir = Utilities.getOrCreateSubDirectory(plateRowDir, HCSImageFormattedData.getPlateColumnDir(wellLocation));
        String wellFileName = HCSImageFormattedData.createWellFileName(tileLocation);
        if (this.containsOriginalData()) {
            IDirectory imageRootDirectoryNode = this.getImageRootDirectoryNode(imageRootDirectory);
            INode imageNode = imageRootDirectoryNode.tryGetNode(imageRelativePath);
            if (imageNode == null) {
                throw new DataStructureException(String.format("No image node with path '%s' could be found in the original directory.", imageRelativePath));
            }
            node = plateColumnDir.tryAddLink(wellFileName, imageNode);
        } else {
            node = plateColumnDir.addFile(new File(imageRootDirectory, imageRelativePath), wellFileName, false);
        }
        if (node == null) {
            throw new StorageException(String.format("Original file name '%s' could not be added at channel %d, plate location '%s' and well location '%s'.", imageRelativePath, channel, wellLocation, tileLocation));
        }
        String standardNodePath = String.valueOf(channelDir.getName()) + '/' + plateRowDir.getName() + '/' + plateColumnDir.getName() + '/' + wellFileName;
        return new IHCSImageFormattedData.NodePath(node, standardNodePath);
    }

    public final Format getFormat() {
        return HCSImageFormatV1_0.HCS_IMAGE_1_0;
    }

    protected final void assertValidFormatAndFormatParameters() {
        super.assertValidFormatAndFormatParameters();
        IFormatParameters formatParameters = this.getFormatParameters();
        HashSet<String> notPresent = new HashSet<String>();
        for (String formatParameterName : this.format.getParameterNames()) {
            if (formatParameters.containsParameter(formatParameterName)) continue;
            notPresent.add(formatParameterName);
        }
        if (!notPresent.isEmpty()) {
            throw new DataStructureException(String.format("Following format parameters '%s' could not be found in the structure.", notPresent));
        }
    }
}

