/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.ILink;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.filesystem.Directory;
import ch.systemsx.cisd.bds.storage.filesystem.File;
import ch.systemsx.cisd.bds.storage.filesystem.Link;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.IOException;

public final class NodeFactory {
    public static INode createNode(java.io.File file) throws EnvironmentFailureException {
        String canonicalPath;
        assert (file != null) : "Unspecified node";
        String absolutePath = file.getAbsolutePath();
        if (!absolutePath.equals(canonicalPath = NodeFactory.getCanonicalPath(file))) {
            return NodeFactory.createLinkNode(file);
        }
        if (file.isDirectory()) {
            return NodeFactory.createDirectoryNode(file);
        }
        return NodeFactory.createFileNode(file);
    }

    private static final String getCanonicalPath(java.io.File file) {
        assert (file != null) : "Unspecified node";
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("Couldn't get canonical path of file '" + file.getAbsolutePath() + "'", ex);
        }
    }

    public static final ILink createLinkNode(String name, java.io.File file) {
        assert (file != null) : "Given file can not be null.";
        assert (name != null) : "Given name can not be null.";
        return new Link(name, NodeFactory.createNode(file));
    }

    public static final ILink createLinkNode(java.io.File file) throws EnvironmentFailureException {
        String canonicalPath = NodeFactory.getCanonicalPath(file);
        String absolutePath = file.getAbsolutePath();
        assert (!absolutePath.equals(canonicalPath)) : String.format("Given file must be a link [absolute=%s,canonical=%s].", absolutePath, canonicalPath);
        return new Link(file.getName(), NodeFactory.createNode(new java.io.File(canonicalPath)));
    }

    public static final IFile createFileNode(java.io.File file) {
        assert (file != null && file.isFile()) : "Given file must be a file";
        return new File(file);
    }

    public static final IDirectory createDirectoryNode(java.io.File file) {
        assert (file != null && file.isDirectory()) : "Given file must be a directory";
        return new Directory(file);
    }

    private NodeFactory() {
    }
}

