/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.highwatermark;

import ch.systemsx.cisd.common.highwatermark.IFreeDiskspaceProvider;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class HighwaterMarkGuard
extends TimerTask {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, HighwaterMarkGuard.class);
    private final Runnable delegate;
    private final IFreeDiskspaceProvider provider;
    private final long minimalFreeSpaceKb;
    private final Notifyer notifyerOrNull;

    public HighwaterMarkGuard(Runnable delegate, IFreeDiskspaceProvider provider, long minimalFreeSpaceKb, boolean notify) {
        assert (delegate != null);
        assert (provider != null);
        assert (minimalFreeSpaceKb > 0L);
        this.delegate = delegate;
        this.provider = provider;
        this.minimalFreeSpaceKb = minimalFreeSpaceKb;
        this.notifyerOrNull = notify ? new Notifyer() : null;
    }

    public void run() {
        Long currentFreeSpaceKb = this.provider.tryGetFreeDiskspaceKb();
        if (this.notifyerOrNull != null) {
            this.notifyerOrNull.notify(this.minimalFreeSpaceKb, currentFreeSpaceKb);
        }
        if (this.belowHighwaterMark(currentFreeSpaceKb)) {
            this.delegate.run();
        }
    }

    private boolean belowHighwaterMark(Long currentFreeSpaceKb) {
        return currentFreeSpaceKb != null && currentFreeSpaceKb >= this.minimalFreeSpaceKb;
    }

    private static final class Notifyer {
        private State state = State.OK;

        private Notifyer() {
        }

        void notify(long minimalFreeSpaceKb, Long currentFreeSpaceKb) {
            if (currentFreeSpaceKb == null) {
                if (this.state == State.OK) {
                    notificationLog.error("Error getting free diskspace on partition, suspending operation.");
                    this.state = State.ERROR;
                }
                return;
            }
            if (currentFreeSpaceKb < minimalFreeSpaceKb) {
                if (this.state != State.LOW) {
                    notificationLog.error(String.format("Highwater mark reached, required: %dkB, found: %dkB, suspending operation.", minimalFreeSpaceKb, currentFreeSpaceKb));
                    this.state = State.LOW;
                }
                return;
            }
            if (this.state != State.OK) {
                notificationLog.info(String.format("%s condition resolved, required: %dkB, found: %dkB, resuming operation.", this.state == State.LOW ? "Low disk space" : "Error", minimalFreeSpaceKb, currentFreeSpaceKb));
                this.state = State.OK;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            OK,
            LOW,
            ERROR;

        }
    }
}

