/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceForRMIChecker {
    public static void assertInterfaceForRMI(Class<?> interfaze) {
        Method[] methods;
        assert (interfaze != null) : "Unspecified interface.";
        assert (interfaze.isInterface()) : "Not an interface " + interfaze;
        HashSet visitedClasses = new HashSet();
        Method[] methodArray = methods = interfaze.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            InterfaceForRMIChecker.assertMethodForRMI(method, visitedClasses);
            ++n2;
        }
    }

    private static void assertMethodForRMI(Method method, Set<Class<?>> visitedClasses) {
        Class<?>[] parameterTypes;
        Class<?>[] classArray = parameterTypes = method.getParameterTypes();
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            InterfaceForRMIChecker.assertSerializable(parameterType, visitedClasses, true);
            ++n2;
        }
        Class<?> returnType = method.getReturnType();
        if (!Void.class.isAssignableFrom(returnType)) {
            InterfaceForRMIChecker.assertSerializable(returnType, visitedClasses, true);
        }
    }

    public static void assertSerializable(Class<?> clazz) {
        InterfaceForRMIChecker.assertSerializable(clazz, new HashSet(), true);
    }

    private static void assertSerializable(Class<?> clazz, Set<Class<?>> visitedClasses, boolean checkImplementsSerializable) {
        assert (clazz != null) : "Unspecified class.";
        if (clazz.isPrimitive() || visitedClasses.contains(clazz)) {
            return;
        }
        visitedClasses.add(clazz);
        if (clazz.isArray()) {
            InterfaceForRMIChecker.assertSerializable(clazz.getComponentType(), visitedClasses, true);
        } else {
            Field[] fields;
            if (checkImplementsSerializable) assert (Serializable.class.isAssignableFrom(clazz)) : clazz + " does not implements java.io.Serializable";
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                boolean isNative = Modifier.isNative(modifiers);
                boolean isStatic = Modifier.isStatic(modifiers);
                boolean isTransient = Modifier.isTransient(modifiers);
                if (!(isNative || isStatic || isTransient)) {
                    Class<?> attributeClass = field.getType();
                    if (!attributeClass.isInterface()) {
                        InterfaceForRMIChecker.assertSerializable(attributeClass, visitedClasses, true);
                    } else {
                        Type genericType = field.getGenericType();
                        if (genericType instanceof ParameterizedType) {
                            Type[] actualTypeArguments;
                            ParameterizedType pt = (ParameterizedType)genericType;
                            Type[] typeArray = actualTypeArguments = pt.getActualTypeArguments();
                            int n3 = actualTypeArguments.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Type type = typeArray[n4];
                                if (type instanceof Class) {
                                    InterfaceForRMIChecker.assertSerializable((Class)type, visitedClasses, true);
                                }
                                ++n4;
                            }
                        }
                    }
                }
                ++n2;
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class)) {
                InterfaceForRMIChecker.assertSerializable(superclass, visitedClasses, false);
            }
        }
    }
}

