/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.security.MessageDigest;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtilities {
    private static final String[] STRINGS = new String[]{"phalanx", "nightmare", "concierge", "asbestos", "cody", "hermit", "nbc", "couplet", "dice", "thumbnail", "finley", "figure", "exclamation", "whoosh", "punish", "servitor", "portend", "boulevard", "bacterial", "dilate", "emboss", "birmingham", "illustrate", "pomona", "truk", "bursitis", "trustworthy", "harriman", "schenectady", "obligate", "oceania", "knew", "quickstep", "woo", "strickland", "sadie", "malabar", "posit", "breadfruit", "grandfather", "vishnu", "vacuous", "melpomene", "assam", "blaine", "taskmaster", "polymeric", "hector", "counterrevolution", "compassionate", "linkage", "distant", "vet", "shako", "eagan", "neutronium", "stony", "lie", "hoydenish", "dial", "hecate", "pinch", "olin", "piglet", "basswood", "yawn", "ouzo", "scrupulosity", "bestiary", "subpoena", "nudge", "baton", "thing", "hallmark", "bossy", "preferential", "bambi", "narwhal", "brighten", "omnipotent", "forsake", "flapping", "orthodoxy", "upcome", "teaspoonful", "wabash", "lipid", "enjoin", "shoshone", "wartime", "gatekeeper", "litigate", "siderite", "sadden", "visage", "boogie", "scald", "equate", "tragic", "ordinary", "wick", "gigawatt", "desultory", "bambi", "aureomycin", "car", "especial", "rescue", "protector", "burnett", "constant", "heroes", "filmstrip", "homeown", "verdant", "governor", "cornwall", "predisposition", "sedan", "resemblant", "satellite", "committeemen", "given", "narragansett", "switzer", "clockwatcher", "sweeten", "monologist", "execrate", "gila", "lad", "mahayanist", "solicitation", "linemen", "reading", "hoard", "phyla", "carcinoma", "glycol", "polymer", "hangmen", "dualism", "betrayal", "corpsman", "stint", "hannah", "balsam", "granola", "charitable", "osborn", "party", "laboratory", "norwich", "laxative", "collude", "rockefeller", "crack", "lamarck", "purposeful", "neuroanotomy", "araby", "crucible", "oratorical", "dramaturgy", "kitty", "pit", "ephesus", "bum", "amuse", "clogging", "joker", "fobbing", "extent", "colossal", "macromolecule", "choppy", "tennessee", "primrose", "glassine", "vampire", "chap", "precursor", "incorrigible", "slither", "interrogate", "spectral", "debut", "creche", "pyrolysis", "homicidal", "sonnet", "gin", "science", "magma", "metaphor", "cobble", "dyer", "narrate", "goody", "optometric"};
    private static final Pattern pattern = Pattern.compile("([a-zA-Z]+)([0-9]+)");

    private StringUtilities() {
    }

    public static String computeMD5Hash(String string) {
        assert (string != null) : "Unspecified string.";
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(string.getBytes("utf8"));
            byte[] messageDigest = algorithm.digest();
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < messageDigest.length) {
                byte b = messageDigest[i];
                builder.append(Integer.toHexString(0xF & b >> 4));
                builder.append(Integer.toHexString(0xF & b));
                ++i;
            }
            return builder.toString();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static String capitalize(String string) {
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1).toLowerCase();
    }

    public static String concatenateWithSpace(List<String> list) {
        return StringUtils.join(list, (String)" ");
    }

    public static String concatenateWithNewLine(List<String> list) {
        return StringUtils.join(list, (String)OSUtilities.LINE_SEPARATOR);
    }

    public static final String[] getStrings(int numberOfStrings) {
        String[] result = new String[numberOfStrings];
        int i = 0;
        while (i < numberOfStrings) {
            result[i] = StringUtilities.getString();
            ++i;
        }
        return result;
    }

    public static final String getString() {
        return STRINGS[(int)(Math.random() * (double)STRINGS.length - 1.0)];
    }

    public static final String[] splitMatrixCoordinate(String text) {
        assert (text != null) : "Given text can not be null.";
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }

    public static final String getOrdinal(int number) {
        assert (number >= 0) : "Given number must be >= 0.";
        int modulo = number % 100;
        if (modulo < 11 || modulo > 13) {
            modulo = number % 10;
            switch (modulo) {
                case 1: {
                    return String.valueOf(number) + "st";
                }
                case 2: {
                    return String.valueOf(number) + "nd";
                }
                case 3: {
                    return String.valueOf(number) + "rd";
                }
            }
        }
        return String.valueOf(number) + "th";
    }
}

