/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.bds.DataSet;
import ch.systemsx.cisd.bds.DataStructureV1_0;
import ch.systemsx.cisd.bds.ExperimentRegistrationTimestamp;
import ch.systemsx.cisd.bds.ExperimentRegistrator;
import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.FormatParameter;
import ch.systemsx.cisd.bds.IFormatParameterFactory;
import ch.systemsx.cisd.bds.IFormattedData;
import ch.systemsx.cisd.bds.Reference;
import ch.systemsx.cisd.bds.ReferenceType;
import ch.systemsx.cisd.bds.Sample;
import ch.systemsx.cisd.bds.UnknownFormatV1_0;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.HCSImageAnnotations;
import ch.systemsx.cisd.bds.hcs.IHCSImageFormattedData;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.hcs.PlateGeometry;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.ILink;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.filesystem.FileStorage;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.utilities.ClassUtils;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessor;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.HCSImageCheckList;
import ch.systemsx.cisd.etlserver.HCSImageFileExtractionResult;
import ch.systemsx.cisd.etlserver.IHCSImageFileAccepter;
import ch.systemsx.cisd.etlserver.IHCSImageFileExtractor;
import ch.systemsx.cisd.etlserver.IProcedureAndDataTypeExtractor;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.PlateDimension;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.util.PlateDimensionParser;
import ch.systemsx.cisd.lims.base.util.StorageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BDSStorageProcessor
extends AbstractStorageProcessor
implements IHCSImageFileAccepter {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, BDSStorageProcessor.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.OPERATION, BDSStorageProcessor.class);
    private static final String PROPERTY_PREFIX = "Property '%s': ";
    private static final String NO_FORMAT_FORMAT = "Property '%s': no valid and known format could be extracted from text '%s'.";
    static final String VERSION_KEY = "version";
    static final String SAMPLE_TYPE_DESCRIPTION_KEY = "sampleTypeDescription";
    static final String SAMPLE_TYPE_CODE_KEY = "sampleTypeCode";
    static final String FORMAT_KEY = "format";
    static final String FILE_EXTRACTOR_KEY = "file-extractor";
    static final String NO_VERSION_FORMAT = "Property '%s': no version could be extracted from text '%s'.";
    private final Format format;
    private final SampleTypeCode sampleType;
    private final String sampleTypeDescription;
    private DataStructureV1_0 dataStructure;
    private File imageFileRootDirectory;
    private File dataStructureDir;
    private IHCSImageFileExtractor imageFileExtractor;
    private List<FormatParameter> formatParameters;
    private IHCSImageFormattedData imageFormattedData;
    private HCSImageCheckList imageCheckList;

    public BDSStorageProcessor(Properties globalProperties) {
        super(globalProperties);
        Version version = BDSStorageProcessor.parseVersion(this.getMandatoryProperty(VERSION_KEY));
        if (!version.equals(new Version(1, 0))) {
            throw new ConfigurationFailureException("Invalid version: " + version);
        }
        this.format = BDSStorageProcessor.parseFormat(this.getMandatoryProperty(FORMAT_KEY));
        this.createFormatParameters();
        this.sampleTypeDescription = this.getMandatoryProperty(SAMPLE_TYPE_DESCRIPTION_KEY);
        if (this.needsImageFileExtractor()) {
            String property = this.getMandatoryProperty(FILE_EXTRACTOR_KEY);
            this.imageFileExtractor = ClassUtils.create(IHCSImageFileExtractor.class, property, this.properties);
        }
        try {
            this.sampleType = SampleTypeCode.getSampleTypeCode(this.getMandatoryProperty(SAMPLE_TYPE_CODE_KEY));
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationFailureException(ex.getMessage());
        }
    }

    private void createFormatParameters() {
        List<String> parameterNames = this.format.getParameterNames();
        IFormatParameterFactory formatParameterFactory = this.format.getFormatParameterFactory();
        this.formatParameters = new ArrayList<FormatParameter>();
        for (String parameterName : parameterNames) {
            String value = this.properties.getProperty(parameterName);
            if (value == null) {
                throw ConfigurationFailureException.fromTemplate("No value has been defined for parameter '%s'", parameterName);
            }
            FormatParameter formatParameter = formatParameterFactory.createFormatParameter(parameterName, value);
            if (formatParameter == null) {
                throw ConfigurationFailureException.fromTemplate("Given value '%s' is not understandable for parameter '%s'", value, parameterName);
            }
            this.formatParameters.add(formatParameter);
        }
    }

    static final Version parseVersion(String versionString) {
        Version version = Version.createVersionFromString(versionString);
        if (version == null) {
            throw ConfigurationFailureException.fromTemplate(NO_VERSION_FORMAT, VERSION_KEY, versionString);
        }
        return version;
    }

    static final Format parseFormat(String formatString) {
        Format format = Format.tryToCreateFormatFromString(formatString);
        if (format == null) {
            throw ConfigurationFailureException.fromTemplate(NO_FORMAT_FORMAT, FORMAT_KEY, formatString);
        }
        return format;
    }

    private final ch.systemsx.cisd.bds.ExperimentIdentifier createExperimentIdentifier(DataSetInformation dataSetInformation) {
        ExperimentIdentifier experimentIdentifier = dataSetInformation.getExperimentIdentifier();
        String projectCode = experimentIdentifier.getProjectCode();
        String experimentCode = experimentIdentifier.getExperimentCode();
        String groupCode = experimentIdentifier.getGroupCode();
        String instanceCode = dataSetInformation.getInstanceCode();
        return new ch.systemsx.cisd.bds.ExperimentIdentifier(instanceCode, groupCode, projectCode, experimentCode);
    }

    private static final void checkDataSetInformation(DataSetInformation dataSetInformation) {
        assert (dataSetInformation != null);
        assert (dataSetInformation.getSampleCode() != null);
        ExperimentIdentifier experimentIdentifier = dataSetInformation.getExperimentIdentifier();
        assert (experimentIdentifier != null);
        BDSStorageProcessor.checkExperimentIdentifier(experimentIdentifier);
    }

    private static final void checkExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        assert (experimentIdentifier.getGroupCode() != null) : "Group code is null";
        assert (experimentIdentifier.getExperimentCode() != null);
        assert (experimentIdentifier.getProjectCode() != null);
    }

    private final DataStructureV1_0 createDataStructure(BaseExperiment experiment, DataSetInformation dataSetInformation, IProcedureAndDataTypeExtractor typeExtractor, File incomingDataSetPath, File rootDir) {
        FileStorage storage = new FileStorage(rootDir);
        DataStructureV1_0 structure = new DataStructureV1_0(storage);
        structure.create();
        structure.setFormat(this.format);
        structure.setExperimentIdentifier(this.createExperimentIdentifier(dataSetInformation));
        structure.setExperimentRegistrationTimestamp(new ExperimentRegistrationTimestamp(experiment.getRegistrationDate()));
        Person registrator = experiment.getRegistrator();
        String firstName = registrator.getFirstName();
        String lastName = registrator.getLastName();
        String email = registrator.getEmail();
        structure.setExperimentRegistrator(new ExperimentRegistrator(firstName, lastName, email));
        structure.setSample(new Sample(dataSetInformation.getSampleCode(), this.sampleType.getCode(), this.sampleTypeDescription));
        structure.setDataSet(BDSStorageProcessor.createDataSet(dataSetInformation, typeExtractor, incomingDataSetPath));
        for (FormatParameter formatParameter : this.formatParameters) {
            structure.addFormatParameter(formatParameter);
        }
        SimpleEntityProperty[] sampleProperties = dataSetInformation.getSampleProperties();
        PlateDimension plateDimension = PlateDimensionParser.tryToGetPlateDimension(sampleProperties);
        if (plateDimension == null) {
            throw new EnvironmentFailureException("Missing plate geometry for the plate registered for sample code '" + dataSetInformation.getSampleCode() + "'.");
        }
        PlateGeometry plateGeometry = new PlateGeometry(plateDimension.getRowsNum(), plateDimension.getColsNum());
        structure.addFormatParameter(new FormatParameter("plate_geometry", plateGeometry));
        return structure;
    }

    private static final DataSet createDataSet(DataSetInformation dataSetInformation, IProcedureAndDataTypeExtractor typeExtractor, File incomingDataSetPath) {
        String dataSetCode = dataSetInformation.getDataSetCode();
        String parentDataSetCode = dataSetInformation.getParentDataSetCode();
        List<String> parentCodes = BDSStorageProcessor.getParentCodeList(parentDataSetCode);
        boolean isMeasured = typeExtractor.getProcedureType(incomingDataSetPath).isDataAcquisition();
        ObservableType observableType = typeExtractor.getObservableType(incomingDataSetPath);
        DataSet dataSet = new DataSet(dataSetCode, observableType.getCode(), Utilities.Boolean.fromBoolean(isMeasured), dataSetInformation.getProductionDate(), dataSetInformation.getProducerCode(), parentCodes);
        return dataSet;
    }

    private static final List<String> getParentCodeList(String parentDataSetCode) {
        if (parentDataSetCode == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(parentDataSetCode);
    }

    private String getPathOf(INode node) {
        StringBuilder builder = new StringBuilder(node.getName());
        IDirectory parent = node.tryToGetParent();
        while (parent != null) {
            builder.insert(0, '/');
            builder.insert(0, parent.getName());
            parent = parent.tryToGetParent();
        }
        return builder.toString();
    }

    private final boolean needsImageFileExtractor() {
        return !this.format.getCode().equals(UnknownFormatV1_0.UNKNOWN_1_0.getCode());
    }

    @Override
    public final File storeData(BaseExperiment experiment, DataSetInformation dataSetInformation, IProcedureAndDataTypeExtractor typeExtractor, IMailClient mailClient, File incomingDataSetDirectory, File rootDirectory) {
        BDSStorageProcessor.checkDataSetInformation(dataSetInformation);
        assert (rootDirectory != null) : "Root directory can not be null.";
        assert (incomingDataSetDirectory != null) : "Incoming data set directory can not be null.";
        assert (typeExtractor != null) : "Unspecified IProcedureAndDataTypeExtractor implementation.";
        this.dataStructureDir = rootDirectory;
        this.dataStructureDir.mkdirs();
        this.dataStructure = this.createDataStructure(experiment, dataSetInformation, typeExtractor, incomingDataSetDirectory, this.dataStructureDir);
        IFormattedData formattedData = this.dataStructure.getFormattedData();
        if (formattedData instanceof IHCSImageFormattedData) {
            this.imageFormattedData = (IHCSImageFormattedData)formattedData;
            int channels = this.imageFormattedData.getChannelCount();
            Geometry plateGeometry = this.imageFormattedData.getPlateGeometry();
            Geometry wellGeometry = this.imageFormattedData.getWellGeometry();
            this.imageCheckList = new HCSImageCheckList(channels, plateGeometry, wellGeometry);
        }
        if (this.needsImageFileExtractor()) {
            this.imageFileRootDirectory = incomingDataSetDirectory;
            HCSImageFileExtractionResult result = this.imageFileExtractor.process(incomingDataSetDirectory, dataSetInformation, this);
            if (operationLog.isInfoEnabled()) {
                operationLog.info(String.format("Extraction of %d files took %s.", result.getTotalFiles(), DurationFormatUtils.formatDurationHMS((long)result.getDuration())));
            }
            if (result.getInvalidFiles().size() > 0) {
                throw UserFailureException.fromTemplate("Following invalid files %s have been found.", CollectionUtils.abbreviate(result.getInvalidFiles(), 10));
            }
            if (result.getTotalFiles() == 0) {
                throw UserFailureException.fromTemplate("No extractable files were found inside a dataset '%s'. Have you changed your naming convention?", incomingDataSetDirectory.getAbsolutePath());
            }
            this.dataStructure.setAnnotations(new HCSImageAnnotations(result.getChannels()));
            this.checkCompleteness(dataSetInformation, incomingDataSetDirectory.getName(), mailClient);
        } else {
            this.dataStructure.getOriginalData().addFile(incomingDataSetDirectory, null, true);
            if (operationLog.isInfoEnabled()) {
                operationLog.info(String.format("File '%s' added to original data.", incomingDataSetDirectory));
            }
        }
        this.dataStructure.close();
        return this.dataStructureDir;
    }

    private void checkCompleteness(DataSetInformation dataSetInformation, String dataSetFileName, IMailClient mailClientOrNull) {
        int numberOfMissingCheckOffs = this.imageCheckList.getNumberOfMissingCheckOffs();
        boolean complete = numberOfMissingCheckOffs == 0;
        DataSet dataSet = this.dataStructure.getDataSet();
        dataSet.setComplete(complete);
        this.dataStructure.setDataSet(dataSet);
        dataSetInformation.setComplete(complete);
        if (numberOfMissingCheckOffs > 0) {
            String message = String.format("Incomplete data set '%s': %d image file(s) missing.", dataSetFileName, numberOfMissingCheckOffs);
            operationLog.warn(message);
            if (mailClientOrNull != null) {
                ExperimentRegistrator registrator = this.dataStructure.getExperimentRegistrator();
                String email = registrator.getEmail();
                if (!StringUtils.isBlank((String)email)) {
                    try {
                        mailClientOrNull.sendMessage("Incomplete data set '" + dataSetFileName + "'", message, email);
                    }
                    catch (EnvironmentFailureException e) {
                        notificationLog.error("Couldn't send the following e-mail to '" + email + "': " + message, e);
                    }
                } else {
                    notificationLog.error("Unspecified e-mail address of experiment registrator " + registrator);
                }
            }
        }
    }

    @Override
    public final void unstoreData(File incomingDataSetDirectory, File storedDataDirectory) {
        if (this.dataStructure == null) {
            return;
        }
        BDSStorageProcessor.checkParameters(incomingDataSetDirectory, storedDataDirectory);
        IDirectory originalData = this.dataStructure.getOriginalData();
        INode node = originalData.tryGetNode(incomingDataSetDirectory.getName());
        if (node != null) {
            File incomingDirectory = incomingDataSetDirectory.getParentFile();
            try {
                node.moveTo(incomingDirectory);
                if (operationLog.isInfoEnabled()) {
                    operationLog.info(String.format("Node '%s' has moved to incoming directory '%s'.", node, incomingDirectory.getAbsolutePath()));
                }
            }
            catch (EnvironmentFailureException ex) {
                notificationLog.error(String.format("Could not move '%s' to incoming directory '%s'.", node, incomingDirectory.getAbsolutePath()), ex);
            }
        }
        FileUtilities.deleteRecursively(storedDataDirectory);
    }

    @Override
    public final File tryGetProprietaryData(File storedDataDirectory) {
        if (this.dataStructure == null) {
            operationLog.error("No data structure defined.");
            return null;
        }
        if (this.imageFormattedData != null && !this.imageFormattedData.containsOriginalData()) {
            operationLog.warn("Original data are not available.");
            return null;
        }
        IDirectory originalData = this.dataStructure.getOriginalData();
        Iterator iterator = originalData.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        INode node = (INode)iterator.next();
        String path = this.getPathOf(node);
        File originalDataFile = new File(path);
        if (!originalDataFile.exists()) {
            operationLog.error("Original data set file '" + originalDataFile.getAbsolutePath() + "' does not exist.");
            return null;
        }
        return originalDataFile;
    }

    @Override
    public final StorageFormat getStorageFormat() {
        return StorageFormat.BDS_DIRECTORY;
    }

    @Override
    public final void accept(int channel, Location wellLocation, Location tileLocation, File imageFile) {
        assert (this.imageFileRootDirectory != null) : "Incoming data set directory has not been set.";
        String imageRelativePath = FileUtilities.getRelativeFile(this.imageFileRootDirectory, imageFile);
        assert (imageRelativePath != null) : "Image relative path should not be null.";
        IHCSImageFormattedData.NodePath nodePath = this.imageFormattedData.addStandardNode(this.imageFileRootDirectory, imageRelativePath, channel, wellLocation, tileLocation);
        this.imageCheckList.checkOff(channel, wellLocation, tileLocation);
        if (nodePath.getNode() instanceof ILink) {
            Reference reference = new Reference(nodePath.getPath(), String.valueOf(this.imageFileRootDirectory.getName()) + '/' + imageRelativePath, ReferenceType.IDENTICAL);
            this.dataStructure.addReference(reference);
        }
    }
}

