/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.IEncapsulatedLimsService;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import org.apache.log4j.Logger;

final class EncapsulatedLimsService
implements IEncapsulatedLimsService {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, EncapsulatedLimsService.class);
    private final String username;
    private final String password;
    private final IETLLIMSService limsService;
    private String sessionToken;

    EncapsulatedLimsService(IETLLIMSService limsService, String username, String password) {
        assert (limsService != null) : "Given IETLLIMSService implementation can not be null.";
        assert (username != null) : "Given username can not be null.";
        assert (password != null) : "Given password can not be null.";
        this.limsService = limsService;
        this.username = username;
        this.password = password;
    }

    private void authenticate() {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Authenticating to LIMS server as user '" + this.username + "'.");
        }
        this.sessionToken = this.limsService.authenticate(this.username, this.password);
        if (this.sessionToken == null) {
            throw new ConfigurationFailureException("Authentication failure to LIMS server. Most probable cause: user or password are invalid.");
        }
    }

    private void checkSessionToken() {
        if (this.sessionToken == null) {
            this.authenticate();
        }
    }

    private final BaseExperiment primGetBaseExperiment(DataSetInformation dataSetInformation) {
        ExperimentIdentifier experimentID = dataSetInformation.getExperimentIdentifier();
        String sampleCode = dataSetInformation.getSampleCode();
        return this.limsService.getBaseExperiment(this.sessionToken, experimentID, sampleCode);
    }

    private final void primRegisterDataSet(DataSetInformation dataSetInfo, String procedureTypeCode, ExternalData data) {
        ExperimentIdentifier experimentID = dataSetInfo.getExperimentIdentifier();
        String sampleCode = dataSetInfo.getSampleCode();
        this.limsService.registerDataSet(this.sessionToken, experimentID, sampleCode, procedureTypeCode, data);
    }

    private final SimpleEntityProperty[] primTryToGetPropertiesOfSampleRegisteredFor(String sampleCode) {
        return this.limsService.tryToGetPropertiesOfTopSampleRegisteredFor(this.sessionToken, sampleCode);
    }

    private final String primCreateDataSetCode() {
        return this.limsService.createDataSetCode(this.sessionToken);
    }

    public final synchronized BaseExperiment getBaseExperiment(DataSetInformation dataSetInformation) {
        assert (dataSetInformation != null) : "Given DataSetInformation can not be null.";
        this.checkSessionToken();
        try {
            return this.primGetBaseExperiment(dataSetInformation);
        }
        catch (InvalidSessionException invalidSessionException) {
            this.authenticate();
            return this.primGetBaseExperiment(dataSetInformation);
        }
    }

    public final synchronized void registerDataSet(DataSetInformation dataSetInfo, String procedureTypeCode, ExternalData data) {
        assert (dataSetInfo != null) : "missing data set information";
        assert (procedureTypeCode != null) : "missing procedure type";
        assert (data != null) : "missing data";
        this.checkSessionToken();
        try {
            this.primRegisterDataSet(dataSetInfo, procedureTypeCode, data);
        }
        catch (InvalidSessionException invalidSessionException) {
            this.authenticate();
            this.primRegisterDataSet(dataSetInfo, procedureTypeCode, data);
        }
    }

    public synchronized SimpleEntityProperty[] tryToGetPropertiesOfTopSampleRegisteredFor(String sampleCode) throws UserFailureException {
        assert (sampleCode != null) : "Given sample code can not be null.";
        this.checkSessionToken();
        try {
            return this.primTryToGetPropertiesOfSampleRegisteredFor(sampleCode);
        }
        catch (InvalidSessionException invalidSessionException) {
            this.authenticate();
            return this.primTryToGetPropertiesOfSampleRegisteredFor(sampleCode);
        }
    }

    public synchronized String createDataSetCode() {
        this.checkSessionToken();
        try {
            return this.primCreateDataSetCode();
        }
        catch (InvalidSessionException invalidSessionException) {
            this.authenticate();
            return this.primCreateDataSetCode();
        }
    }

    public synchronized int getVersion() {
        this.checkSessionToken();
        return this.limsService.getVersion();
    }
}

