/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.utilities.IPathImmutableCopier;
import ch.systemsx.cisd.common.utilities.RecursiveHardLinkMaker;
import ch.systemsx.cisd.etlserver.FileBasedFile;
import ch.systemsx.cisd.etlserver.IFile;
import ch.systemsx.cisd.etlserver.IFileFactory;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class FileBasedFileFactory
implements IFileFactory {
    private static final long DEFAULT_MILLIS_TO_SLEEP_AFTER_COPY_FAILS = 3000L;
    private static final int DEFAULT_MAX_COPY_RETRIES = 7;
    private final IPathImmutableCopier hardLinkCopierOrNull;

    public FileBasedFileFactory(boolean hardLinkInsteadOfCopy, long millisToWaitForCopyCompletion) {
        this.hardLinkCopierOrNull = FileBasedFileFactory.tryGetHardLinkCopier(hardLinkInsteadOfCopy, millisToWaitForCopyCompletion);
    }

    private static IPathImmutableCopier tryGetHardLinkCopier(boolean hardLinkInsteadOfCopy, long millisToWaitForCopyCompletion) {
        if (hardLinkInsteadOfCopy) {
            if (millisToWaitForCopyCompletion > 0L) {
                return RecursiveHardLinkMaker.tryCreateRetrying(millisToWaitForCopyCompletion, 7, 3000L);
            }
            return RecursiveHardLinkMaker.tryCreate();
        }
        return null;
    }

    private IFile wrap(File file) {
        return new FileBasedFile(file, this.hardLinkCopierOrNull);
    }

    public IFile create(String path) {
        assert (path != null) : "Unspecified path.";
        File file = new File(path);
        return this.wrap(file);
    }

    public IFile create(IFile baseDir, String relativePath) {
        assert (baseDir != null) : "Unspecified base directory.";
        assert (relativePath != null) : "Unspecified relative pate";
        assert (FilenameUtils.getPrefixLength((String)relativePath) == 0) : String.format("Given relative path '%s' is not relative.", relativePath);
        return this.wrap(new File(baseDir.getAbsolutePath(), relativePath));
    }
}

