/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class SampleAnt {
    @Option(name="-help", usage="print this message")
    private boolean help = false;
    @Option(name="-projecthelp", usage="print project help information")
    private boolean projecthelp;
    @Option(name="-version", usage="print the version information and exit")
    private boolean version;
    @Option(name="-diagnostics", usage="print information that might be helpful to\ndiagnose or report problems.")
    private boolean diagnostics;
    @Option(name="-quiet", usage="be extra quiet")
    private boolean quiet;
    @Option(name="-verbose", usage="be extra verbose")
    private boolean verbose;
    @Option(name="-debug", usage="print debugging information")
    private boolean debug;
    @Option(name="-emacs", usage="produce logging information without adornments")
    private boolean emacs;
    private List<File> lib = new Vector<File>();
    @Option(name="-logger", usage="the class which is to perform logging", metaVar="<classname>")
    private String logger;
    @Option(name="-listener", usage="the class which is to perform", metaVar="<classname>")
    private String listener;
    @Option(name="-noinput", usage="do not allow interactive input")
    private boolean noinput;
    @Option(name="-buildfile", usage="use given buildfile", metaVar="<file>")
    private File buildfile;
    private TreeMap<String, String> props = new TreeMap();
    @Option(name="-keep-going", usage="execute all targets that do not depend\non failed target(s)")
    private boolean keepGoing;
    @Option(name="-propertyfile", usage="load all properties from file with -D\nproperties taking precedence", metaVar="<name>")
    private File propertyfile;
    @Option(name="-inputhandler", usage="the class which will handle input requests", metaVar="<class>")
    private String inputhandler;
    @Option(name="-find", usage="(s)earch for buildfile towards the root of\nthe filesystem and use it", metaVar="<file>")
    private File file;
    private int nice = 5;
    @Option(name="-nouserlib", usage="Run ant without using the jar files from\n${user.home}/.ant/lib")
    private boolean nouserlib;
    @Option(name="-noclasspath", usage="Run ant without using CLASSPATH")
    private boolean noclasspath;
    @Argument
    private List<String> targets;

    @Option(name="-h")
    private void setHelp(boolean h) {
        this.help = h;
    }

    @Option(name="-p")
    private void setProjecthelp(boolean p) {
        this.projecthelp = p;
    }

    @Option(name="-q")
    private void setQuiet(boolean q) {
        this.quiet = q;
    }

    @Option(name="-v")
    private void setVerbose(boolean v) {
        this.verbose = v;
    }

    @Option(name="-d")
    private void setDebug(boolean d) {
        this.debug = d;
    }

    @Option(name="-e")
    private void setEmacs(boolean e) {
        this.emacs = e;
    }

    @Option(name="-lib", usage="specifies a path to search for jars and classes", metaVar="<path>")
    private void setLib(String s) {
        String[] files = s.split(System.getProperty("path.separator"));
        int i = 0;
        while (i < files.length) {
            this.lib.add(new File(files[i]));
            ++i;
        }
    }

    @Option(name="-file", usage="        ''", metaVar="<file>")
    private void setBuildfile1(File f) {
        this.buildfile = f;
    }

    @Option(name="-f", usage="        ''", metaVar="<file>")
    private void setBuildfile2(File f) {
        this.buildfile = f;
    }

    @Option(name="-k")
    private void setKeepGoing(boolean kg) {
        this.keepGoing = kg;
    }

    @Option(name="-s", metaVar="<file>")
    private void setFile(File f) {
        this.file = f;
    }

    @Option(name="-nice", usage="A niceness value for the main thread:\n1 (lowest) to 10 (highest); 5 is the default")
    private void setNice(int n) {
        if (n > 0 && n < 11) {
            this.nice = n;
        }
    }

    public static void main(String[] args) throws IOException {
        SampleAnt bean = new SampleAnt();
        try {
            bean.parseArgs(args);
            bean.showResult();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseArgs(String[] args) throws IOException {
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            int start = e.getMessage().indexOf(34) + 1;
            int end = e.getMessage().lastIndexOf(34);
            String wrongArgument = e.getMessage().substring(start, end);
            System.err.println("Unknown argument: " + wrongArgument);
            System.err.println("ant [options] [target [target2 [target3] ...]]");
            parser.printUsage(System.err);
            System.err.println();
            throw new IOException();
        }
    }

    public void showResult() {
        System.out.println("SampleAnt was configured with...");
        System.out.println("  help         : " + this.help);
        System.out.println("  projecthelp  : " + this.projecthelp);
        System.out.println("  version      : " + this.version);
        System.out.println("  diagnostics  : " + this.diagnostics);
        System.out.println("  quiet        : " + this.quiet);
        System.out.println("  verbose      : " + this.verbose);
        System.out.println("  debug        : " + this.debug);
        System.out.println("  emacs        : " + this.emacs);
        System.out.println("  lib");
        for (File f : this.lib) {
            System.out.println("    - " + f);
        }
        System.out.println("  logger       : " + this.logger);
        System.out.println("  listener     : " + this.listener);
        System.out.println("  noinput      : " + this.noinput);
        System.out.println("  buildfile    : " + this.buildfile);
        System.out.println("  properties");
        for (String key : this.props.keySet()) {
            System.out.println("    - " + key + " = " + this.props.get(key));
        }
        System.out.println("  keepGoing    : " + this.keepGoing);
        System.out.println("  propertyfile : " + this.propertyfile);
        System.out.println("  inputhandler : " + this.inputhandler);
        System.out.println("  buildfile    : " + this.file);
        System.out.println("  nice         : " + this.nice);
        System.out.println("  nouserlib    : " + this.nouserlib);
        System.out.println("  noclasspath  : " + this.noclasspath);
        System.out.println("");
        System.out.println("  targets");
        for (String t : this.targets) {
            System.out.println("    - " + t);
        }
        System.out.println("");
    }
}

