/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.crowd;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.crowd.IRequestExecutor;
import ch.systemsx.cisd.authentication.crowd.SOAPAttributeContentHandler;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdAuthenticationService
implements IAuthenticationService {
    private static final String EMAIL_PROPERTY_KEY = "mail";
    private static final String LAST_NAME_PROPERTY_KEY = "sn";
    private static final String FIRST_NAME_PROPERTY_KEY = "givenName";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CrowdAuthenticationService.class);
    static final MessageFormat AUTHENTICATE_APPL = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soap:Body>\n   <authenticateApplication xmlns=\"urn:SecurityServer\">\n     <in0>\n       <credential xmlns=\"http://authentication.integration.crowd.atlassian.com\">\n         <credential>{1}</credential>\n       </credential>\n       <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</name>\n       <validationFactors xmlns=\"http://authentication.integration.crowd.atlassian.com\"                           xsi:nil=\"true\" />\n     </in0>\n   </authenticateApplication>\n </soap:Body>\n</soap:Envelope>\n");
    static final MessageFormat AUTHENTICATE_USER = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soap:Body>\n   <authenticatePrincipal xmlns=\"urn:SecurityServer\">\n     <in0>\n       <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</name>\n       <token xmlns=\"http://authentication.integration.crowd.atlassian.com\">{1}</token>\n     </in0>\n     <in1>\n       <application xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</application>\n       <credential xmlns=\"http://authentication.integration.crowd.atlassian.com\">\n         <credential>{3}</credential>\n       </credential>\n       <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{2}</name>\n       <validationFactors xmlns=\"http://authentication.integration.crowd.atlassian.com\" />\n     </in1>\n   </authenticatePrincipal>\n </soap:Body>\n</soap:Envelope>\n");
    static final MessageFormat FIND_PRINCIPAL_BY_NAME = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n   <soap:Body>\n       <findPrincipalByName xmlns=\"urn:SecurityServer\">\n           <in0>\n               <name xmlns=\"http://authentication.integration.crowd.atlassian.com\">{0}</name>\n               <token xmlns=\"http://authentication.integration.crowd.atlassian.com\">{1}</token>\n           </in0>\n           <in1>{2}</in1>\n       </findPrincipalByName>\n   </soap:Body>\n</soap:Envelope>\n");
    private final String url;
    private final String application;
    private final String applicationPassword;
    private final IRequestExecutor requestExecutor;

    private static IRequestExecutor createExecutor() {
        return new IRequestExecutor(){

            public String execute(String serviceUrl, String message) {
                try {
                    HttpClient client = new HttpClient();
                    PostMethod post = new PostMethod(serviceUrl);
                    StringRequestEntity entity = new StringRequestEntity(message, "application/soap+xml", "utf-8");
                    post.setRequestEntity((RequestEntity)entity);
                    String response = null;
                    try {
                        client.executeMethod((HttpMethod)post);
                        response = post.getResponseBodyAsString();
                    }
                    finally {
                        post.releaseConnection();
                    }
                    return response;
                }
                catch (Exception ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        };
    }

    public CrowdAuthenticationService(String host, int port, String application, String applicationPassword) {
        this("https://" + host + ":" + port + "/crowd/services/SecurityServer", application, applicationPassword, CrowdAuthenticationService.createExecutor());
    }

    public CrowdAuthenticationService(String url, String application, String applicationPassword, IRequestExecutor requestExecutor) {
        this.url = url;
        this.application = application;
        this.applicationPassword = applicationPassword;
        this.requestExecutor = requestExecutor;
        if (operationLog.isDebugEnabled()) {
            String msg = "A new CrowdAuthenticationService instance has been created for [url=" + url + ", application=" + application + "]";
            operationLog.debug(msg);
        }
    }

    @Override
    public final void check() throws EnvironmentFailureException, ConfigurationFailureException {
        try {
            String response = this.execute(AUTHENTICATE_APPL, this.application, this.applicationPassword);
            if (CrowdAuthenticationService.pickElementContent(response, "token") == null) {
                throw new EnvironmentFailureException("Application '" + this.application + "' couldn't be authenticated: " + response);
            }
        }
        catch (EnvironmentFailureException ex) {
            throw ex;
        }
        catch (CheckedExceptionTunnel ex) {
            throw new EnvironmentFailureException(ex.getMessage(), ex.getCause());
        }
        catch (RuntimeException ex) {
            throw new EnvironmentFailureException(ex.getMessage(), ex);
        }
    }

    @Override
    public final String authenticateApplication() {
        String applicationToken = StringEscapeUtils.unescapeXml(this.execute("token", AUTHENTICATE_APPL, this.application, this.applicationPassword));
        if (applicationToken == null) {
            operationLog.error("CROWD: application '" + this.application + "' failed to authenticate.");
        } else if (operationLog.isDebugEnabled()) {
            operationLog.debug("CROWD: application '" + this.application + "' successfully authenticated.");
        }
        return applicationToken;
    }

    @Override
    public final boolean authenticateUser(String applicationToken, String user, String password) {
        assert (applicationToken != null);
        assert (user != null);
        String userToken = StringEscapeUtils.unescapeXml(this.execute("out", AUTHENTICATE_USER, this.application, applicationToken, user, password));
        if (operationLog.isInfoEnabled()) {
            String msg = "CROWD: authentication of user '" + user + "', application '" + this.application + "': ";
            operationLog.info(String.valueOf(msg) + (userToken == null ? "FAILED." : "SUCCESS."));
        }
        return userToken != null;
    }

    @Override
    public final Principal getPrincipal(String applicationToken, String user) {
        String xmlResponse = null;
        try {
            xmlResponse = this.execute(FIND_PRINCIPAL_BY_NAME, this.application, applicationToken, user);
            Map<String, String> parseXmlResponse = CrowdAuthenticationService.parseXmlResponse(xmlResponse);
            Principal principal = null;
            if (parseXmlResponse.size() >= 1) {
                principal = CrowdAuthenticationService.createPrincipal(user, parseXmlResponse);
            } else if (operationLog.isDebugEnabled()) {
                operationLog.debug("No SOAPAttribute element could be found in the SOAP XML response.");
            }
            if (principal == null) {
                throw new IllegalArgumentException("Cannot find user '" + user + "'.");
            }
            return principal;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String message = "Parsing XML response '" + xmlResponse + "' throws an Exception.";
            throw new EnvironmentFailureException(message, ex);
        }
    }

    private static final Map<String, String> parseXmlResponse(String xmlResponse) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        SOAPAttributeContentHandler contentHandler = new SOAPAttributeContentHandler();
        xmlReader.setContentHandler(contentHandler);
        StringReader stringReader = new StringReader(xmlResponse);
        xmlReader.parse(new InputSource(stringReader));
        stringReader.close();
        return contentHandler.getSoapAttributes();
    }

    private static final Principal createPrincipal(String user, Map<String, String> soapAttributes) {
        String firstName = soapAttributes.get(FIRST_NAME_PROPERTY_KEY);
        String lastName = soapAttributes.get(LAST_NAME_PROPERTY_KEY);
        String email = soapAttributes.get(EMAIL_PROPERTY_KEY);
        return new Principal(user, firstName, lastName, email, soapAttributes);
    }

    private final String execute(String responseElement, MessageFormat template, String ... args) {
        String response = this.execute(template, args);
        return CrowdAuthenticationService.pickElementContent(response, responseElement);
    }

    private final String execute(MessageFormat template, String ... args) {
        Object[] decodedArguments = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            decodedArguments[i] = StringEscapeUtils.escapeXml(args[i]);
            ++i;
        }
        return this.requestExecutor.execute(this.url, template.format(decodedArguments));
    }

    private static final String pickElementContent(String xmlString, String element) {
        if (xmlString == null) {
            operationLog.error("Response of web service is invalid (null). We were looking for element '" + element + "'.");
            return null;
        }
        int index = CrowdAuthenticationService.getIndex(xmlString, "<", element, 0);
        if (index < 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("Element '" + element + "' could not be found in '" + StringUtils.abbreviate(xmlString, 50) + "'.");
            }
            return null;
        }
        if ((index = xmlString.indexOf(">", index)) < 0) {
            operationLog.error("Element '" + element + "' seems to be present but XML is invalid: '" + StringUtils.abbreviate(xmlString, 50) + "'.");
            return null;
        }
        int endIndex = CrowdAuthenticationService.getIndex(xmlString, "</", String.valueOf(element) + ">", index);
        if (endIndex < 0) {
            operationLog.error("Start tag of element '" + element + "' is present but end tag is missing: '" + StringUtils.abbreviate(xmlString, 50) + "'.");
            return null;
        }
        return xmlString.substring(index + 1, endIndex);
    }

    private static int getIndex(String xmlString, String begin, String element, int startIndex) {
        String regex = ".*(" + begin + "(\\w*:)?" + element + ").*";
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(xmlString);
        boolean result = matcher.matches();
        if (!result) {
            return -1;
        }
        int index = matcher.start(1);
        return index;
    }
}

