/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.file.FileBasedLineStore;
import ch.systemsx.cisd.authentication.file.LineBasedUserStore;
import ch.systemsx.cisd.authentication.file.Parameters;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import java.io.File;
import java.io.IOException;
import jline.ConsoleReader;

public class PasswordEditorCommand {
    private static final String ENTER_NEW_PASSWORD_MSG = "Enter new password: ";
    private static final String ENTER_PASSWORD_MSG = "Enter the user's password: ";
    private static final File PASSWORD_FILE = new File("etc/passwd");
    private static ConsoleReader consoleReader;

    private static final ConsoleReader getConsoleReader() {
        if (consoleReader == null) {
            try {
                consoleReader = new ConsoleReader();
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("ConsoleReader could not be instantiated.", ex);
            }
        }
        return consoleReader;
    }

    private static final String readPassword(String message) {
        try {
            return PasswordEditorCommand.getConsoleReader().readLine(message, Character.valueOf('*'));
        }
        catch (IOException ex) {
            System.err.println("Error reading password (" + ex.getMessage() + ").");
            System.exit(1);
            return null;
        }
    }

    private static File getPasswordFile() {
        if (System.getProperty("PASSWORD_FILE") != null) {
            return new File(System.getProperty("PASSWORD_FILE"));
        }
        return PASSWORD_FILE;
    }

    private static void printUser(UserEntry user) {
        System.out.printf("%-20s  %-20s  %-20s  %-20s\n", user.getUserId(), user.getFirstName(), user.getLastName(), user.getEmail());
    }

    private static void printHeader() {
        System.out.printf("%-20s  %-20s  %-20s  %-20s\n", "User ID", "First Name", "Last Name", "Email");
    }

    public static void main(String[] args) {
        try {
            Parameters params = new Parameters(args);
            FileBasedLineStore lineStore = new FileBasedLineStore(PasswordEditorCommand.getPasswordFile(), "Password file");
            LineBasedUserStore userStore = new LineBasedUserStore(lineStore);
            switch (params.getCommand()) {
                case ADD: {
                    String userId = params.getUserId();
                    UserEntry userOrNull = userStore.tryGetUser(userId);
                    if (userOrNull != null) {
                        System.err.printf("User '%s' already exists.\n", userId);
                        System.exit(1);
                    }
                    String password = params.tryGetPassword() != null ? params.tryGetPassword() : PasswordEditorCommand.readPassword(ENTER_NEW_PASSWORD_MSG);
                    UserEntry user = new UserEntry(params.getUserId(), params.getFirstName(), params.getLastName(), params.getEmail(), password);
                    userStore.addOrUpdateUser(user);
                    break;
                }
                case CHANGE: {
                    String userId = params.getUserId();
                    UserEntry userOrNull = userStore.tryGetUser(userId);
                    if (userOrNull == null) {
                        System.err.printf("User '%s' does not exist.\n", userId);
                        System.exit(1);
                        return;
                    }
                    if (params.getFirstName() != null) {
                        userOrNull.setFirstName(params.getFirstName());
                    }
                    if (params.getLastName() != null) {
                        userOrNull.setLastName(params.getLastName());
                    }
                    if (params.getEmail() != null) {
                        userOrNull.setEmail(params.getEmail());
                    }
                    if (params.tryGetPassword() != null) {
                        userOrNull.setPassword(params.tryGetPassword());
                    } else if (params.isChangePassword()) {
                        userOrNull.setPassword(PasswordEditorCommand.readPassword(ENTER_NEW_PASSWORD_MSG));
                    }
                    userStore.addOrUpdateUser(userOrNull);
                    break;
                }
                case LIST: {
                    PasswordEditorCommand.printHeader();
                    for (UserEntry user : userStore.listUsers()) {
                        PasswordEditorCommand.printUser(user);
                    }
                    break;
                }
                case REMOVE: {
                    String userId = params.getUserId();
                    if (!userStore.removeUser(userId)) {
                        System.err.printf("User '%s' does not exist.\n", userId);
                        System.exit(1);
                    }
                    break;
                }
                case SHOW: {
                    String userId = params.getUserId();
                    UserEntry userOrNull = userStore.tryGetUser(userId);
                    if (userOrNull == null) {
                        System.err.printf("User '%s' does not exist.\n", userId);
                        System.exit(1);
                        return;
                    }
                    PasswordEditorCommand.printHeader();
                    PasswordEditorCommand.printUser(userOrNull);
                    break;
                }
                case TEST: {
                    String userId = params.getUserId();
                    UserEntry userOrNull = userStore.tryGetUser(userId);
                    if (userOrNull == null) {
                        System.err.printf("User '%s' does not exist.\n", userId);
                        System.exit(1);
                        return;
                    }
                    String password = PasswordEditorCommand.readPassword(ENTER_PASSWORD_MSG);
                    if (userStore.isPasswordCorrect(userId, password)) {
                        System.out.printf("User '%s' successfully authenticated.\n", userId);
                        break;
                    }
                    System.out.printf("User '%s' authentication failed.\n", userId);
                }
            }
        }
        catch (HighLevelException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }
}

