/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import ch.systemsx.cisd.common.collections.ToStringDefaultConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static final <T> String abbreviate(T[] objects, int maxLength) {
        return CollectionUtils.abbreviate(objects, maxLength, true);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength) {
        return CollectionUtils.abbreviate(collection, maxLength, true);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, CollectionStyle style) {
        return CollectionUtils.abbreviate(objects, maxLength, true, ToStringDefaultConverter.getInstance(), style);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, CollectionStyle style) {
        return CollectionUtils.abbreviate(collection, maxLength, ToStringDefaultConverter.getInstance(), style);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(collection, maxLength, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, IToStringConverter<? super T> converter, CollectionStyle style) {
        return CollectionUtils.abbreviate(collection, maxLength, true, converter, style);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, boolean showLeft) {
        return CollectionUtils.abbreviate(objects, maxLength, showLeft, ToStringDefaultConverter.getInstance());
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, boolean showLeft) {
        return CollectionUtils.abbreviate(collection, maxLength, showLeft, ToStringDefaultConverter.getInstance());
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, boolean showLeft, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(objects, maxLength, showLeft, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(T[] objects, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(objects, -1, false, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, boolean showLeft, IToStringConverter<? super T> converter) {
        return CollectionUtils.abbreviate(collection, maxLength, showLeft, converter, CollectionStyle.DEFAULT);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, boolean showLeft, IToStringConverter<? super T> converter, CollectionStyle style) {
        assert (objects != null) : "Given objects can not be null.";
        return CollectionUtils.abbreviate((Collection)Arrays.asList(objects), maxLength, showLeft, converter, style);
    }

    public static final <T> String abbreviate(T[] objects, int maxLength, IToStringConverter<? super T> converter, CollectionStyle style) {
        assert (objects != null) : "Given objects can not be null.";
        return CollectionUtils.abbreviate((Collection)Arrays.asList(objects), maxLength, true, converter, style);
    }

    public static final <T> String abbreviate(Collection<T> collection, int maxLength, boolean showLeft, IToStringConverter<? super T> converter, CollectionStyle style) {
        assert (collection != null) : "Given collection can not be null.";
        assert (converter != null) : "Given converter can not be null.";
        assert (style != null) : "Given style can not be null.";
        StringBuilder builder = new StringBuilder(style.getCollectionStart());
        Iterator<T> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext() && (i < maxLength || maxLength < 0)) {
            if (i > 0) {
                builder.append(style.getCollectionSeparator());
            }
            builder.append(converter.toString(iterator.next()));
            ++i;
        }
        int size = collection.size();
        if (maxLength > 0 && maxLength < size) {
            builder.append(style.getCollectionSeparator());
            builder.append("...");
            if (showLeft) {
                builder.append(" (").append(size - maxLength).append(" left)");
            }
        }
        builder.append(style.getCollectionEnd());
        return builder.toString();
    }
}

