/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.AbstractCollectionDecorator;
import ch.systemsx.cisd.common.collections.Validator;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredCollection<E>
extends AbstractCollectionDecorator<E> {
    protected final Validator<E> validator;

    public static <E> Collection<E> decorate(Collection<E> coll, Validator<E> validator) {
        return new FilteredCollection<E>(coll, validator);
    }

    protected FilteredCollection(Collection<E> collection, Validator<E> validator) {
        super(FilteredCollection.filterCollection(collection, validator));
        assert (validator != null);
        this.validator = validator;
    }

    protected static final <E> Collection<E> filterCollection(Collection<? extends E> collection, Validator<E> validator) {
        if (collection == null) {
            return null;
        }
        Iterator<E> iter = collection.iterator();
        while (iter.hasNext()) {
            if (validator.isValid(iter.next())) continue;
            iter.remove();
        }
        return collection;
    }

    protected boolean isValid(E object) {
        return this.validator.isValid(object);
    }

    @Override
    public final boolean add(E object) {
        if (this.isValid(object)) {
            return this.getCollection().add(object);
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E e : collection) {
            if (!this.add(e) || changed) continue;
            changed = true;
        }
        return changed;
    }
}

