/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrencyUtilities {
    public static final long NO_TIMEOUT = -1L;
    public static final long IMMEDIATE_TIMEOUT = 0L;

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis) throws StopException {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, null, true);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, boolean stopOnInterrupt) throws StopException {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, null, stopOnInterrupt);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, ISimpleLogger loggerOrNull, String operationNameOrNull, boolean stopOnInterrupt) throws StopException {
        ExecutionResult<T> result = ConcurrencyUtilities.getResult(future, timeoutMillis, loggerOrNull, operationNameOrNull);
        switch (result.getStatus()) {
            case COMPLETE: {
                return result.tryGetResult();
            }
            case EXCEPTION: {
                Throwable cause = result.tryGetException();
                assert (cause != null);
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)cause);
            }
            case INTERRUPTED: {
                if (stopOnInterrupt) {
                    throw new StopException();
                }
                return null;
            }
        }
        return null;
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, null, null);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, ISimpleLogger loggerOrNull, String operationNameOrNull) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, true, loggerOrNull, operationNameOrNull);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, boolean cancelOnTimeout, ISimpleLogger loggerOrNull, String operationNameOrNull) {
        String operationName = operationNameOrNull == null ? "UNKNOWN" : operationNameOrNull;
        try {
            return ExecutionResult.create(future.get(ConcurrencyUtilities.transform(timeoutMillis), TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException timeoutException) {
            if (cancelOnTimeout) {
                future.cancel(true);
            }
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.DEBUG, String.format("%s took longer than %f s, cancelled.", operationName, Float.valueOf((float)timeoutMillis / 1000.0f)));
            }
            return ExecutionResult.createTimedOut();
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.DEBUG, String.format("%s got interrupted.", operationName));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (loggerOrNull != null) {
                String message = cause == null || cause.getMessage() == null ? "<no message>" : cause.getMessage();
                String className = cause == null ? "<unknown class>" : cause.getClass().getSimpleName();
                loggerOrNull.log(LogLevel.ERROR, String.format("%s has caused an exception: %s [%s]", operationName, message, className));
            }
            return ExecutionResult.createExceptional(cause == null ? ex : cause);
        }
    }

    private static long transform(long timeoutMillis) {
        return timeoutMillis < 0L ? Long.MAX_VALUE : timeoutMillis;
    }
}

