/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.ExecutionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionResult<T> {
    private final ExecutionStatus status;
    private final T resultOrNull;
    private final Throwable exceptionOrNull;

    private ExecutionResult(ExecutionStatus status, T resultOrNull, Throwable exceptionOrNull) {
        this.status = status;
        this.resultOrNull = resultOrNull;
        this.exceptionOrNull = exceptionOrNull;
    }

    static <T> ExecutionResult<T> create(T resultOrNull) {
        return new ExecutionResult<T>(ExecutionStatus.COMPLETE, resultOrNull, null);
    }

    static <T> ExecutionResult<T> createExceptional(Throwable exception) {
        assert (exception != null);
        return new ExecutionResult<Object>(ExecutionStatus.EXCEPTION, null, exception);
    }

    static <T> ExecutionResult<T> createTimedOut() {
        return new ExecutionResult<Object>(ExecutionStatus.TIMED_OUT, null, null);
    }

    static <T> ExecutionResult<T> createInterrupted() {
        return new ExecutionResult<Object>(ExecutionStatus.INTERRUPTED, null, null);
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public T tryGetResult() {
        return this.resultOrNull;
    }

    public Throwable tryGetException() {
        return this.exceptionOrNull;
    }
}

