/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.NamedCallable;
import ch.systemsx.cisd.common.concurrent.NamedFutureTask;
import ch.systemsx.cisd.common.concurrent.NamedRunnable;
import ch.systemsx.cisd.common.concurrent.NamingThreadFactory;
import ch.systemsx.cisd.common.concurrent.PoolNameThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingThreadPoolExecutor
extends ThreadPoolExecutor {
    public static final long DEFAULT_KEEP_ALIVE_TIME_MILLIS = 10000L;

    public NamingThreadPoolExecutor(String poolName) {
        super(1, Integer.MAX_VALUE, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTimeMillis) {
        super(corePoolSize, maximumPoolSize, keepAliveTimeMillis, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize) {
        super(corePoolSize, maximumPoolSize, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamingThreadFactory(poolName), handler);
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamingThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public NamingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamingThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (!(r instanceof NamedRunnable)) {
            return;
        }
        String runnableName = ((NamedRunnable)r).getRunnableName();
        if (t instanceof PoolNameThread) {
            ((PoolNameThread)t).setRunnableName(runnableName);
        } else {
            t.setName(runnableName);
        }
        super.beforeExecute(t, r);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask ftask = task instanceof NamedRunnable ? new NamedFutureTask<Object>((NamedRunnable)task, null) : new FutureTask(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask ftask = task instanceof NamedRunnable ? new NamedFutureTask<T>((NamedRunnable)task, result) : new FutureTask(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask ftask = task instanceof NamedCallable ? new NamedFutureTask<T>((NamedCallable)task) : new FutureTask(task);
        this.execute(ftask);
        return ftask;
    }
}

