/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

import java.sql.SQLException;

public final class SQLStateUtils {
    public static final String FOREIGN_KEY_VIOLATION = "23503";
    public static final String UNIQUE_VIOLATION = "23505";
    public static final String INVALID_CATALOG_NAME = "3D000";
    public static final String DUPLICATE_OBJECT = "42710";
    public static final String DUPLICATE_DATABASE = "42P04";

    private SQLStateUtils() {
    }

    public static final String getSqlState(Throwable ex) {
        SQLException sqlException;
        Throwable th = ex.getCause();
        String sqlState = null;
        if (th instanceof SQLException && (sqlState = (sqlException = (SQLException)th).getSQLState()) == null) {
            return SQLStateUtils.getSqlState(sqlException);
        }
        return sqlState;
    }

    public static final boolean isDuplicateObject(String sqlState) {
        return DUPLICATE_OBJECT.equalsIgnoreCase(sqlState);
    }

    public static final boolean isDuplicateDatabase(String sqlState) {
        return DUPLICATE_DATABASE.equalsIgnoreCase(sqlState);
    }

    public static final boolean isInvalidCatalogName(String sqlState) {
        return INVALID_CATALOG_NAME.equalsIgnoreCase(sqlState);
    }

    public static final boolean isUniqueViolation(String sqlState) {
        return UNIQUE_VIOLATION.equalsIgnoreCase(sqlState);
    }

    public static final boolean isForeignKeyViolation(String sqlState) {
        return FOREIGN_KEY_VIOLATION.equalsIgnoreCase(sqlState);
    }
}

