/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.highwatermark;

import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.highwatermark.IFreeDiskspaceProvider;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FreeDiskspaceCacheUpdater
extends TimerTask {
    static final long DEFAULT_UPDATE_PERIOD_MILLIS = 60000L;
    static final long DEFAULT_DELEGATE_TIMEOUT_MILLIS = 10000L;
    static final int DEFAULT_MAX_FAILURE_COUNT_IGNORE = 3;
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, FreeDiskspaceCacheUpdater.class);
    private final ExecutorService executor;
    private final IFreeDiskspaceProvider delegate;
    private final AtomicReference<Long> freeSpaceKb;
    private final long delegateTimeoutMillis;
    private final int maxFailureCountIgnore;
    private int failureCount;
    private final Callable<Long> delegatingFreeDiskspaceCallable = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            return FreeDiskspaceCacheUpdater.this.delegate.tryGetFreeDiskspaceKb();
        }
    };

    FreeDiskspaceCacheUpdater(IFreeDiskspaceProvider delegate, AtomicReference<Long> freeSpaceKb, long updatePeriodMillis, long delegateTimeoutMillis, int maxFailureCountIgnore) {
        this.delegate = delegate;
        this.freeSpaceKb = freeSpaceKb;
        this.delegateTimeoutMillis = delegateTimeoutMillis;
        this.maxFailureCountIgnore = maxFailureCountIgnore;
        this.executor = new NamingThreadPoolExecutor("Highwater Mark Checker", 1, Integer.MAX_VALUE, 2L * updatePeriodMillis);
    }

    @Override
    public void run() {
        if (machineLog.isTraceEnabled()) {
            machineLog.trace("Updating free diskspace, old value was " + this.freeSpaceKb.get() + "kB.");
        }
        Future<Long> future = this.executor.submit(this.delegatingFreeDiskspaceCallable);
        ExecutionResult<Long> result = ConcurrencyUtilities.getResult(future, this.delegateTimeoutMillis);
        this.updateFailureCount(result);
        if (this.isSuitableForSetting(result)) {
            this.freeSpaceKb.set(result.tryGetResult());
        }
        this.handle(result);
    }

    private boolean isSuitableForSetting(ExecutionResult<Long> result) {
        return result.tryGetResult() != null || this.failureCount > this.maxFailureCountIgnore;
    }

    private void updateFailureCount(ExecutionResult<Long> result) {
        this.failureCount = result.tryGetResult() == null ? ++this.failureCount : 0;
    }

    private void handle(ExecutionResult<Long> result) {
        switch (result.getStatus()) {
            case COMPLETE: {
                if (!machineLog.isDebugEnabled()) break;
                machineLog.debug("Updated free diskspace, new value is " + result.tryGetResult() + "kB.");
                break;
            }
            case TIMED_OUT: {
                machineLog.error("Timeout when trying to update free diskspace.");
                break;
            }
            case INTERRUPTED: {
                this.cancel();
                machineLog.warn("Interrupted when updating free diskspace, canceling.");
                break;
            }
            case EXCEPTION: {
                machineLog.error("Exception when trying to update free diskspace", result.tryGetException());
            }
        }
    }
}

