/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class SlowInputStream
extends FilterInputStream {
    private final long speed;

    public SlowInputStream(InputStream inputStream, long speed) {
        super(inputStream);
        this.speed = speed;
    }

    private final void pause(int bytes) {
        long sleepMillis = (long)bytes * 1000L / this.speed;
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException interruptedException) {}
    }

    public final int read() throws IOException {
        this.pause(1);
        return this.in.read();
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        this.pause(len);
        return this.in.read(b, off, len);
    }
}

