/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.IProcess;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessRunner;
import ch.systemsx.cisd.common.utilities.IPathImmutableCopier;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecursiveHardLinkMaker
implements IPathImmutableCopier {
    private static final String HARD_LINK_EXEC = "ln";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RecursiveHardLinkMaker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RecursiveHardLinkMaker.class);
    private final String linkExecPath;
    private final RetryingOperationTimeout singleFileLinkTimeout;

    private RecursiveHardLinkMaker(String linkExecPath, RetryingOperationTimeout singleFileLinkTimeoutOrNull) {
        this.linkExecPath = linkExecPath;
        this.singleFileLinkTimeout = singleFileLinkTimeoutOrNull != null ? singleFileLinkTimeoutOrNull : this.createNoTimeout();
    }

    private RetryingOperationTimeout createNoTimeout() {
        return new RetryingOperationTimeout(0L, 1, 0L);
    }

    public static final IPathImmutableCopier create(String linkExecPath) {
        return new RecursiveHardLinkMaker(linkExecPath, null);
    }

    public static final IPathImmutableCopier tryCreateRetrying(long millisToWaitForCompletion, int maxRetryOnFailure, long millisToSleepOnFailure) {
        RetryingOperationTimeout timeout = new RetryingOperationTimeout(millisToWaitForCompletion, maxRetryOnFailure, millisToSleepOnFailure);
        return RecursiveHardLinkMaker.tryCreate(timeout);
    }

    public static final IPathImmutableCopier tryCreate() {
        return RecursiveHardLinkMaker.tryCreate(null);
    }

    private static final IPathImmutableCopier tryCreate(RetryingOperationTimeout singleFileLinkTimeoutOrNull) {
        File lnExec = OSUtilities.findExecutable(HARD_LINK_EXEC);
        if (lnExec == null) {
            return null;
        }
        return new RecursiveHardLinkMaker(lnExec.getAbsolutePath(), singleFileLinkTimeoutOrNull);
    }

    @Override
    public final File tryCopy(File path, File destinationDirectory, String nameOrNull) {
        assert (path != null) : "Given path can not be null.";
        assert (destinationDirectory != null && destinationDirectory.isDirectory()) : "Given destination directory can not be null and must be a directory.";
        String destName = nameOrNull == null ? path.getName() : nameOrNull;
        File destFile = new File(destinationDirectory, destName);
        if (destFile.exists()) {
            operationLog.error(String.format("File '%s' already exists in given destination directory '%s'", destName, destinationDirectory));
            return null;
        }
        if (operationLog.isTraceEnabled()) {
            operationLog.trace(String.format("Creating a hard link copy of '%s' in '%s'.", path.getPath(), destinationDirectory.getPath()));
        }
        return this.tryMakeCopy(path, destinationDirectory, nameOrNull);
    }

    private final File tryMakeCopy(File resource, File destinationDirectory, String nameOrNull) {
        if (resource.isFile()) {
            return this.tryCreateHardLinkIn(resource, destinationDirectory, nameOrNull);
        }
        String name = nameOrNull == null ? resource.getName() : nameOrNull;
        File dir = RecursiveHardLinkMaker.tryCreateDir(name, destinationDirectory);
        if (dir == null) {
            return null;
        }
        File[] files = resource.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                StopException.check();
                if (this.tryMakeCopy(file, dir, null) == null) {
                    return null;
                }
                ++n2;
            }
        } else if (!resource.exists()) {
            operationLog.error(String.format("Path '%s' vanished during processing.", resource));
        } else {
            operationLog.error(String.format("Found path '%s' that is neither a file nor a directory.", resource));
        }
        return dir;
    }

    private static final File tryCreateDir(String name, File destDir) {
        File dir = new File(destDir, name);
        boolean ok = dir.mkdir();
        if (!ok) {
            if (dir.isDirectory()) {
                machineLog.error(String.format("Directory %s already exists in %s", name, destDir.getAbsolutePath()));
                ok = true;
            } else {
                machineLog.error(String.format("Could not create directory %s inside %s.", name, destDir.getAbsolutePath()));
                if (dir.isFile()) {
                    machineLog.error("There is a file with a same name.");
                }
            }
        }
        return ok ? dir : null;
    }

    private final File tryCreateHardLinkIn(final File file, File destDir, String nameOrNull) {
        assert (file.isFile()) : String.format("Given file '%s' must be a file and is not.", file);
        final File destFile = new File(destDir, nameOrNull == null ? file.getName() : nameOrNull);
        final List<String> cmd = this.createLnCmdLine(file, destFile);
        IProcessTask processTask = new IProcessTask(){

            public boolean run() {
                boolean result = ProcessExecutionHelper.runAndLog(cmd, operationLog, machineLog, RecursiveHardLinkMaker.this.singleFileLinkTimeout.getMillisToWaitForCompletion());
                if (!result && destFile.exists() && RecursiveHardLinkMaker.checkIfIdenticalContent(file, destFile)) {
                    machineLog.warn("Link creator reported failure, but the exact copy of the file '" + file.getPath() + "' seems to exist in '" + destFile.getPath() + "'. Error will be ignored.");
                    result = true;
                }
                return result;
            }
        };
        boolean ok = RecursiveHardLinkMaker.runRepeatableProcess(processTask, this.singleFileLinkTimeout.getMaxRetryOnFailure(), this.singleFileLinkTimeout.getMillisToSleepOnFailure());
        return ok ? destFile : null;
    }

    private static boolean checkIfIdenticalContent(File file1, File file2) {
        StopException.check();
        try {
            return FileUtils.contentEquals((File)file1, (File)file2);
        }
        catch (IOException e) {
            machineLog.warn("It was not possible to compare the content of the file to check if creating links worked: " + e.getMessage());
            return false;
        }
    }

    private final List<String> createLnCmdLine(File srcFile, File destFile) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.linkExecPath);
        tokens.add(srcFile.getAbsolutePath());
        tokens.add(destFile.getAbsolutePath());
        return tokens;
    }

    private static boolean runRepeatableProcess(final IProcessTask task, final int maxRetryOnFailure, final long millisToSleepOnFailure) {
        IProcess process = new IProcess(){
            private boolean succeded;

            public int getMaxRetryOnFailure() {
                return maxRetryOnFailure;
            }

            public long getMillisToSleepOnFailure() {
                return millisToSleepOnFailure;
            }

            public boolean succeeded() {
                return this.succeded;
            }

            public void run() {
                this.succeded = task.run();
            }
        };
        new ProcessRunner(process);
        return process.succeeded();
    }

    static interface IProcessTask {
        public boolean run();
    }

    private static class RetryingOperationTimeout {
        private final long millisToWaitForCompletion;
        private final int maxRetryOnFailure;
        private final long millisToSleepOnFailure;

        private RetryingOperationTimeout(long millisToWaitForCompletion, int maxRetryOnFailure, long millisToSleepOnFailure) {
            this.millisToWaitForCompletion = millisToWaitForCompletion;
            this.maxRetryOnFailure = maxRetryOnFailure;
            this.millisToSleepOnFailure = millisToSleepOnFailure;
        }

        public long getMillisToWaitForCompletion() {
            return this.millisToWaitForCompletion;
        }

        public int getMaxRetryOnFailure() {
            return this.maxRetryOnFailure;
        }

        public long getMillisToSleepOnFailure() {
            return this.millisToSleepOnFailure;
        }
    }
}

