/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IDatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.ISqlScriptProvider;
import ch.systemsx.cisd.dbmigration.LogEntry;
import ch.systemsx.cisd.dbmigration.SqlScriptProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DBMigrationEngine {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DBMigrationEngine.class);
    private final boolean shouldCreateFromScratch;
    private final ISqlScriptProvider scriptProvider;
    private final IDatabaseAdminDAO adminDAO;
    private final IDatabaseVersionLogDAO logDAO;
    private final ISqlScriptExecutor scriptExecutor;

    public static ISqlScriptProvider createOrMigrateDatabaseAndGetScriptProvider(DatabaseConfigurationContext context, String databaseVersion) {
        assert (context != null) : "Unspecified database configuration context.";
        assert (StringUtils.isNotBlank(databaseVersion)) : "Unspecified database version.";
        IDAOFactory migrationDAOFactory = context.createDAOFactory();
        String scriptFolder = context.getScriptFolder();
        String databaseEngineCode = context.getDatabaseEngineCode();
        SqlScriptProvider sqlScriptProvider = new SqlScriptProvider(scriptFolder, databaseEngineCode);
        DBMigrationEngine migrationEngine = new DBMigrationEngine(migrationDAOFactory, sqlScriptProvider, context.isCreateFromScratch());
        migrationEngine.migrateTo(databaseVersion);
        return sqlScriptProvider;
    }

    public DBMigrationEngine(IDAOFactory daoFactory, ISqlScriptProvider scriptProvider, boolean shouldCreateFromScratch) {
        this.adminDAO = daoFactory.getDatabaseDAO();
        this.logDAO = daoFactory.getDatabaseVersionLogDAO();
        this.scriptExecutor = daoFactory.getSqlScriptExecutor();
        this.scriptProvider = scriptProvider;
        this.shouldCreateFromScratch = shouldCreateFromScratch;
    }

    public void migrateTo(String version) {
        if (this.shouldCreateFromScratch) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Dropping database.");
            }
            this.adminDAO.dropDatabase();
        }
        if (!this.databaseExists()) {
            this.setupDatabase(version);
            return;
        }
        LogEntry entry = this.getAndCheckLastLogEntry();
        String databaseVersion = entry.getVersion();
        if (version.equals(databaseVersion)) {
            if (operationLog.isDebugEnabled()) {
                String databaseName = this.adminDAO.getDatabaseName();
                if (operationLog.isInfoEnabled()) {
                    operationLog.debug("No migration needed for database '" + databaseName + "'. It has the right version (" + version + ").");
                }
            }
        } else if (version.compareTo(databaseVersion) > 0) {
            String databaseName;
            if (operationLog.isInfoEnabled()) {
                databaseName = this.adminDAO.getDatabaseName();
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Trying to migrate database '" + databaseName + "' from version " + databaseVersion + " to " + version + ".");
                }
            }
            this.migrate(databaseVersion, version);
            if (operationLog.isInfoEnabled()) {
                databaseName = this.adminDAO.getDatabaseName();
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Database '" + databaseName + "' successfully migrated from version " + databaseVersion + " to " + version + ".");
                }
            }
        } else {
            String databaseName = this.adminDAO.getDatabaseName();
            String message = "Cannot revert database '" + databaseName + "' from version " + databaseVersion + " to earlier version " + version + ".";
            operationLog.error(message);
            throw new EnvironmentFailureException(message);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("Using database '%s'", this.adminDAO.getDatabaseURL()));
        }
    }

    private LogEntry getAndCheckLastLogEntry() {
        LogEntry entry = this.logDAO.getLastEntry();
        if (entry == null) {
            String message = "Inconsistent database: Empty database version log.";
            operationLog.error(message);
            throw new EnvironmentFailureException(message);
        }
        if (entry.getRunStatus() != LogEntry.RunStatus.SUCCESS) {
            String message = "Inconsistent database: Last creation/migration didn't succeed. Last log entry: " + entry;
            operationLog.error(message);
            throw new EnvironmentFailureException(message);
        }
        return entry;
    }

    private void setupDatabase(String version) {
        this.adminDAO.createOwner();
        if (this.scriptProvider.isDumpRestore(version)) {
            this.adminDAO.restoreDatabaseFromDump(this.scriptProvider.getDumpFolder(version), version);
        } else {
            this.createEmptyDatabase(version);
            this.fillWithInitialData(version);
        }
        if (operationLog.isInfoEnabled()) {
            String databaseName = this.adminDAO.getDatabaseName();
            operationLog.info("Database '" + databaseName + "' version " + version + " has been successfully created.");
        }
    }

    private void createEmptyDatabase(String version) {
        this.adminDAO.createDatabase();
        this.executeSchemaScript(version);
    }

    private void executeSchemaScript(String version) {
        Script schemaScript = this.scriptProvider.tryGetSchemaScript(version);
        if (schemaScript == null) {
            String message = "No schema script found for version " + version;
            operationLog.error(message);
            throw new ConfigurationFailureException(message);
        }
        this.scriptExecutor.execute(schemaScript, true, this.logDAO);
        Script functionScript = this.scriptProvider.tryGetFunctionScript(version);
        if (functionScript == null) {
            operationLog.debug("No function script found for version " + version);
        } else {
            this.scriptExecutor.execute(functionScript, false, this.logDAO);
        }
    }

    private void fillWithInitialData(String version) {
        Script initialDataScript = this.scriptProvider.tryGetDataScript(version);
        if (initialDataScript != null) {
            this.scriptExecutor.execute(initialDataScript, true, this.logDAO);
        }
    }

    private void migrate(String fromVersion, String toVersion) {
        String nextVersion;
        String version = fromVersion;
        do {
            Script migrationScript;
            if ((migrationScript = this.scriptProvider.tryGetMigrationScript(version, nextVersion = DBMigrationEngine.increment(version))) == null) {
                String databaseName = this.adminDAO.getDatabaseName();
                String message = "Cannot migrate database '" + databaseName + "' from version " + version + " to " + nextVersion + " because of missing migration script.";
                operationLog.error(message);
                throw new EnvironmentFailureException(message);
            }
            long time = System.currentTimeMillis();
            this.scriptExecutor.execute(migrationScript, true, this.logDAO);
            if (!operationLog.isInfoEnabled()) continue;
            operationLog.info("Successfully migrated from version " + version + " to " + nextVersion + " in " + (System.currentTimeMillis() - time) + " msec");
        } while (!(version = nextVersion).equals(toVersion));
    }

    static String increment(String version) {
        char[] characters = new char[version.length()];
        version.getChars(0, characters.length, characters, 0);
        int i = characters.length - 1;
        while (i >= 0) {
            char c = characters[i];
            if (c != '9') {
                characters[i] = (char)(c + '\u0001');
                break;
            }
            characters[i] = 48;
            --i;
        }
        return new String(characters);
    }

    private final boolean databaseExists() {
        boolean result = this.logDAO.canConnectToDatabase();
        if (!result && operationLog.isInfoEnabled()) {
            operationLog.info("Database '" + this.adminDAO.getDatabaseName() + "' does not exist.");
        }
        return result;
    }
}

