/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.dbmigration.IDatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.LogEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

public class DatabaseVersionLogDAO
extends SimpleJdbcDaoSupport
implements IDatabaseVersionLogDAO {
    public static final String DB_VERSION_LOG = "database_version_logs";
    private static final String ENCODING = "utf8";
    private static final String RUN_EXCEPTION = "run_exception";
    private static final String MODULE_CODE = "module_code";
    private static final String RUN_STATUS_TIMESTAMP = "run_status_timestamp";
    private static final String RUN_STATUS = "run_status";
    private static final String MODULE_NAME = "module_name";
    private static final String DB_VERSION = "db_version";
    private static final String SELECT_LAST_ENTRY = "select * from database_version_logs where run_status_timestamp in (select max(run_status_timestamp) from database_version_logs)";
    final LobHandler lobHandler;

    private static byte[] getAsByteArray(String string) {
        try {
            return string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    public DatabaseVersionLogDAO(DataSource dataSource, LobHandler lobHandler) {
        this.setDataSource(dataSource);
        this.lobHandler = lobHandler;
    }

    public boolean canConnectToDatabase() {
        try {
            this.getLastEntry();
            return true;
        }
        catch (BadSqlGrammarException badSqlGrammarException) {
            return false;
        }
        catch (CannotGetJdbcConnectionException cannotGetJdbcConnectionException) {
            return false;
        }
    }

    public void createTable(Script script) {
        JdbcTemplate template = this.getJdbcTemplate();
        template.execute(script.getCode());
    }

    public LogEntry getLastEntry() {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List entries = template.query(SELECT_LAST_ENTRY, (ParameterizedRowMapper)new LogEntryRowMapper(this.lobHandler), new Object[0]);
        return entries.size() == 0 ? null : (LogEntry)entries.get(entries.size() - 1);
    }

    public void logStart(final Script moduleScript) {
        JdbcTemplate template = this.getJdbcTemplate();
        AbstractLobCreatingPreparedStatementCallback callback = new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                ps.setString(1, moduleScript.getVersion());
                ps.setString(2, moduleScript.getName());
                ps.setString(3, LogEntry.RunStatus.START.toString());
                ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                lobCreator.setBlobAsBytes(ps, 5, DatabaseVersionLogDAO.getAsByteArray(moduleScript.getCode()));
            }
        };
        template.execute("insert into database_version_logs (db_version,module_name,run_status,run_status_timestamp,module_code) values (?,?,?,?,?)", (PreparedStatementCallback)callback);
    }

    public void logSuccess(Script moduleScript) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("update database_version_logs SET run_status = ? , run_status_timestamp = ? where db_version = ? and module_name = ?", new Object[]{LogEntry.RunStatus.SUCCESS.toString(), new Date(System.currentTimeMillis()), moduleScript.getVersion(), moduleScript.getName()});
    }

    public void logFailure(final Script moduleScript, Throwable runException) {
        final StringWriter stringWriter = new StringWriter();
        runException.printStackTrace(new PrintWriter(stringWriter));
        JdbcTemplate template = this.getJdbcTemplate();
        AbstractLobCreatingPreparedStatementCallback callback = new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                ps.setString(1, LogEntry.RunStatus.FAILED.toString());
                ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                lobCreator.setBlobAsBytes(ps, 3, DatabaseVersionLogDAO.getAsByteArray(stringWriter.toString()));
                ps.setString(4, moduleScript.getVersion());
                ps.setString(5, moduleScript.getName());
            }
        };
        template.execute("update database_version_logs SET run_status = ?, run_status_timestamp = ?, run_exception = ? where db_version = ? and module_name = ?", (PreparedStatementCallback)callback);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogEntryRowMapper
    implements ParameterizedRowMapper<LogEntry> {
        private final LobHandler lobHandler;

        LogEntryRowMapper(LobHandler lobHandler) {
            this.lobHandler = lobHandler;
        }

        public LogEntry mapRow(ResultSet rs, int rowNum) throws SQLException {
            LogEntry logEntry = new LogEntry();
            logEntry.setVersion(rs.getString(DatabaseVersionLogDAO.DB_VERSION));
            logEntry.setModuleName(rs.getString(DatabaseVersionLogDAO.MODULE_NAME));
            logEntry.setRunStatus(rs.getString(DatabaseVersionLogDAO.RUN_STATUS));
            logEntry.setRunStatusTimestamp(rs.getDate(DatabaseVersionLogDAO.RUN_STATUS_TIMESTAMP));
            try {
                logEntry.setModuleCode(new String(this.lobHandler.getBlobAsBytes(rs, DatabaseVersionLogDAO.MODULE_CODE), DatabaseVersionLogDAO.ENCODING));
            }
            catch (UnsupportedEncodingException ex) {
                throw new CheckedExceptionTunnel(ex);
            }
            logEntry.setRunException(this.lobHandler.getClobAsString(rs, DatabaseVersionLogDAO.RUN_EXCEPTION));
            return logEntry;
        }
    }
}

