/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.dbmigration.ISqlScriptProvider;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class SqlScriptProvider
implements ISqlScriptProvider {
    private static final String DUMP_FILENAME = ".DUMP";
    private static final String SQL_FILE_TYPE = ".sql";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SqlScriptProvider.class);
    private final String genericScriptFolder;
    private final String specificScriptFolder;

    public SqlScriptProvider(String schemaScriptRootFolder, String databaseEngineCode) {
        this.genericScriptFolder = String.valueOf(schemaScriptRootFolder) + "/generic";
        this.specificScriptFolder = String.valueOf(schemaScriptRootFolder) + "/" + databaseEngineCode;
    }

    public boolean isDumpRestore(String version) {
        return this.getDumprestoreFile(version).exists();
    }

    public void markAsDumpRestorable(String version) throws IOException {
        FileUtils.touch((File)this.getDumprestoreFile(version));
    }

    private File getDumprestoreFile(String version) {
        return new File(this.getDumpFolder(version), DUMP_FILENAME);
    }

    public File getDumpFolder(String version) {
        return new File(this.specificScriptFolder, version);
    }

    public Script tryGetSchemaScript(String version) {
        return this.tryLoadScript("schema-" + version + SQL_FILE_TYPE, version);
    }

    public Script tryGetFunctionScript(String version) {
        return this.tryLoadScript("function-" + version + SQL_FILE_TYPE, version);
    }

    public Script tryGetDataScript(String version) {
        return this.tryLoadScript("data-" + version + SQL_FILE_TYPE, version);
    }

    public Script tryGetMigrationScript(String fromVersion, String toVersion) {
        String scriptName = "migration-" + fromVersion + "-" + toVersion + SQL_FILE_TYPE;
        return this.tryLoadScript(scriptName, toVersion, "migration");
    }

    private Script tryLoadScript(String scriptName, String scriptVersion) {
        return this.tryLoadScript(scriptName, scriptVersion, scriptVersion);
    }

    private Script tryLoadScript(String scriptName, String scriptVersion, String prefix) {
        Script script = this.tryPrimLoadScript(String.valueOf(this.specificScriptFolder) + "/" + prefix, scriptName, scriptVersion);
        if (script == null) {
            script = this.tryPrimLoadScript(String.valueOf(this.genericScriptFolder) + "/" + prefix, scriptName, scriptVersion);
        }
        return script;
    }

    private Script tryPrimLoadScript(String scriptFolder, String scriptName, String scriptVersion) {
        String scriptPath = String.valueOf(scriptFolder) + "/" + scriptName;
        String resource = "/" + scriptPath;
        String script = FileUtilities.loadToString(this.getClass(), resource);
        if (script == null) {
            File file = new File(scriptFolder, scriptName);
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("Resource '" + resource + "' could not be found. Trying '" + file.getPath() + "'.");
            }
            if (!file.exists()) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug("File '" + file.getPath() + "' does not exist.");
                }
                return null;
            }
            script = FileUtilities.loadToString(file);
        }
        return new Script(scriptPath, script, scriptVersion);
    }
}

