/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.h2;

import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.DatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IDatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.SqlScriptExecutor;
import ch.systemsx.cisd.dbmigration.h2.H2AdminDAO;
import ch.systemsx.cisd.dbmigration.h2.H2MassUploader;
import java.sql.SQLException;
import javax.sql.DataSource;

public class H2DAOFactory
implements IDAOFactory {
    private final IDatabaseAdminDAO databaseDAO;
    private final ISqlScriptExecutor sqlScriptExecutor;
    private final IDatabaseVersionLogDAO databaseVersionLogDAO;
    private final IMassUploader massUploader;

    public H2DAOFactory(DatabaseConfigurationContext context) {
        DataSource dataSource = context.getDataSource();
        this.sqlScriptExecutor = new SqlScriptExecutor(dataSource, context.isScriptSingleStepMode());
        this.databaseVersionLogDAO = new DatabaseVersionLogDAO(dataSource, context.getLobHandler());
        try {
            this.massUploader = new H2MassUploader(dataSource, context.getSequenceNameMapper());
        }
        catch (SQLException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
        this.databaseDAO = new H2AdminDAO(context.getAdminDataSource(), this.sqlScriptExecutor, this.massUploader, context.getDatabaseName(), context.getDatabaseURL());
    }

    public IDatabaseAdminDAO getDatabaseDAO() {
        return this.databaseDAO;
    }

    public ISqlScriptExecutor getSqlScriptExecutor() {
        return this.sqlScriptExecutor;
    }

    public IDatabaseVersionLogDAO getDatabaseVersionLogDAO() {
        return this.databaseVersionLogDAO;
    }

    public IMassUploader getMassUploader() {
        return this.massUploader;
    }
}

