/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ExperimentIdentifier
implements Serializable {
    private static final long serialVersionUID = 18L;
    static final String CODE_SEPARATOR = "::";
    private String projectCode;
    private String experimentCode;
    private String groupCode;

    public ExperimentIdentifier() {
    }

    public ExperimentIdentifier(String projectCode, String experimentCode) {
        this.setProjectCode(projectCode);
        this.setExperimentCode(experimentCode);
    }

    public final String getExperimentCode() {
        return this.experimentCode;
    }

    public final void setExperimentCode(String experimentCode) {
        assert (experimentCode != null);
        this.experimentCode = experimentCode;
    }

    public final String getProjectCode() {
        return this.projectCode;
    }

    public final void setProjectCode(String projectCode) {
        assert (projectCode != null);
        this.projectCode = projectCode;
    }

    public final String describe() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getProjectCode());
        builder.append(CODE_SEPARATOR);
        builder.append(this.getExperimentCode());
        return builder.toString();
    }

    public final boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Experiment=");
        builder.append(this.getExperimentCode());
        builder.append(",Project=");
        builder.append(this.getProjectCode());
        builder.append("]");
        return builder.toString();
    }

    public final void setGroupCode(String groupCode) {
        assert (groupCode != null);
        this.groupCode = groupCode;
    }

    public String getGroupCode() {
        return this.groupCode;
    }
}

