/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import ch.systemsx.cisd.lims.base.IDataSetService;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.ILIMSServiceFactory;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIBasedLIMSServiceFactory
implements ILIMSServiceFactory {
    public static final ILIMSServiceFactory INSTANCE = new RMIBasedLIMSServiceFactory();

    private RMIBasedLIMSServiceFactory() {
    }

    private static final <T> T createServiceStub(Class<T> serviceClass, String serviceURL) {
        HttpInvokerProxyFactoryBean httpInvokerProxy = new HttpInvokerProxyFactoryBean();
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceClass);
        httpInvokerProxy.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)new CommonsHttpInvokerRequestExecutor());
        httpInvokerProxy.afterPropertiesSet();
        return RMIBasedLIMSServiceFactory.getCastedService(httpInvokerProxy);
    }

    private static final <T> T getCastedService(HttpInvokerProxyFactoryBean httpInvokerProxy) {
        return (T)httpInvokerProxy.getObject();
    }

    @Override
    public IETLLIMSService createETLLIMSService(String baseURL) {
        return RMIBasedLIMSServiceFactory.createServiceStub(IETLLIMSService.class, String.valueOf(baseURL) + "/rmi-etl");
    }

    @Override
    public ILIMSService createLIMSService(String baseURL) {
        return RMIBasedLIMSServiceFactory.createServiceStub(ILIMSService.class, String.valueOf(baseURL) + "/rmi");
    }

    @Override
    public IDataSetService createDataSetService(String baseURL) {
        return RMIBasedLIMSServiceFactory.createServiceStub(IDataSetService.class, String.valueOf(baseURL) + "/rmi-data-set");
    }
}

