/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.client.commands.AbstractAssignPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.EntityTypeUtils;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.commands.factory.ExperimentPropertyFillerFactory;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssignExperimentPropertyTypeCommand
extends AbstractAssignPropertyTypeCommand {
    private static final String NAME = "assign-experiment-property-type";
    private static final String PROJECT_PARSER_PROPERTY = "project";
    private static AssignExperimentPropertyTypeCommand instance;

    AssignExperimentPropertyTypeCommand() {
        super(NAME, EntityKind.EXPERIMENT);
    }

    public static final synchronized AssignExperimentPropertyTypeCommand getInstance() {
        if (instance == null) {
            instance = new AssignExperimentPropertyTypeCommand();
        }
        return instance;
    }

    @Override
    final AbstractAssignPropertyTypeCommand.AbstractAssignPropertyTypeParameters createParameters(String[] arguments) {
        return new Parameters(arguments);
    }

    @Override
    final IParserObjectFactory<EntityPropertyFiller> createParserObjectFactory(IPropertyMapper propertyMapper) {
        return new ExperimentPropertyFillerFactory(propertyMapper);
    }

    @Override
    final String getEntityTypeCode(IEntityTypeCodeProvider entityTypeCodeProvider) throws UserFailureException {
        return EntityTypeUtils.getExperimentTypeCode(entityTypeCodeProvider).getCode();
    }

    private final class Parameters
    extends AbstractAssignPropertyTypeCommand.AbstractAssignPropertyTypeParameters {
        public Parameters(String[] args) {
            super(args, AssignExperimentPropertyTypeCommand.this.getName(), EntityKind.EXPERIMENT, Parameters.getEntityCodeGenericArgLabel(EntityKind.EXPERIMENT));
        }

        @Option(name="f", longName="load-values", metaVar="load-values", usage="The file with three columns: code, project and value. Value will be used to set appropriate property for an experiment with a given code")
        final void setFile(String filePath) {
            super.setFile(filePath);
        }
    }
}

