/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BisTabFileLoader<T>
extends TabFileLoader<T> {
    private static final String MESSAGE_FORMAT = "A problem has occurred while parsing line %d of file '%s':\n  %s";
    private static final String ERROR_IN_FILE_MESSAGE_FORMAT = "A problem has occurred while parsing file '%s':\n  %s";

    public BisTabFileLoader(IParserObjectFactoryFactory<T> factory) {
        super(factory);
    }

    @Override
    public final List<T> load(File file) {
        try {
            if (!file.exists()) {
                throw new UserFailureException("Given file '" + file.getAbsolutePath() + "' does not exist or is not a file.");
            }
            List loadedList = super.load(file);
            if (loadedList.size() == 0) {
                throw new UserFailureException("Given file '" + file.getAbsolutePath() + "' is empty or does not contain any meaningful information.");
            }
            return loadedList;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UserFailureException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ParserException parserException) {
            throw new UserFailureException(parserException.getMessage(), parserException);
        }
    }

    @Override
    protected final void throwParsingException(ParsingException parsingException, File file) {
        RuntimeException causeException = parsingException.getCauseRuntimeException();
        String message = causeException == null ? parsingException.getMessage() : causeException.getMessage();
        throw UserFailureException.fromTemplate(MESSAGE_FORMAT, parsingException.getLineNumber(), file, message);
    }

    @Override
    protected void throwParserException(ParserException ex, File file) {
        String message = ex.getMessage();
        throw UserFailureException.fromTemplate(ERROR_IN_FILE_MESSAGE_FORMAT, file, message);
    }
}

