/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.FileProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractExperimentInfoCommand;
import ch.systemsx.cisd.lims.client.model.ExperimentAttachmentTableModel;

public final class ListExperimentAttachmentsCommand
extends AbstractExperimentInfoCommand {
    private static final String NAME = "list-experiment-attachments";
    private static ListExperimentAttachmentsCommand instance;

    private ListExperimentAttachmentsCommand() {
        super(NAME);
    }

    public static final synchronized ListExperimentAttachmentsCommand getInstance() {
        if (instance == null) {
            instance = new ListExperimentAttachmentsCommand();
        }
        return instance;
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        AbstractExperimentInfoCommand.ExperimentInfoParameters parameters = super.createParameters(arguments);
        Experiment experiment = super.tryFetchExperimentBasicAndPrintHeader(sessionToken, parameters);
        if (experiment == null) {
            return 1;
        }
        FileProperty[] fileProperties = experiment.getFileProperties();
        this.printTable(new ExperimentAttachmentTableModel(fileProperties, parameters.isPrettyPrinted()), parameters);
        return 0;
    }
}

