/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentTypeCode;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.BaseExperimentTableModel;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.parameters.AbstractExperimentFilterParameter;
import ch.systemsx.cisd.lims.client.parameters.IOutputTypeParameters;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

public final class ListExperimentsCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-experiments";
    private static ListExperimentsCommand instance;

    private ListExperimentsCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        QueryRestriction queryRestriction;
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        BaseExperiment[] experiments = limsService.listExperiments(sessionToken, queryRestriction = parameters.getQueryRestriction());
        int numberOfExperiments = experiments.length;
        if (numberOfExperiments == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No experiments have been found" + Utilities.createMessageInfoSnippet(queryRestriction) + ".");
            return 0;
        }
        this.sortById(experiments);
        BaseExperimentTableModel model = new BaseExperimentTableModel(experiments, "", parameters.isPrettyPrinted());
        ILinePrinter linePrinter = ListExperimentsCommand.createSimpleLinePrinter();
        IOutputPrinter printer = ListExperimentsCommand.createPrinter(parameters, linePrinter, "");
        printer.printTableModel(model, "");
        return 0;
    }

    private void sortById(BaseExperiment[] experiments) {
        Arrays.sort(experiments);
    }

    public static final synchronized ListExperimentsCommand getInstance() {
        if (instance == null) {
            instance = new ListExperimentsCommand();
        }
        return instance;
    }

    private static final class Parameters
    extends AbstractExperimentFilterParameter
    implements IOutputTypeParameters {
        private static final String EXPERIMENT_TYPE_CODE_GENERIC_ARG = "<experiment-type-code>";
        @Option(name="a", longName="show-also-invalid", usage="Lists also invalid experiments")
        private Boolean showInvalidated;
        @Option(name="P", longName="pretty-print", usage="Output in a pretty printed format")
        private Boolean isPrettyPrinted;

        Parameters(String[] args) {
            super(args, ListExperimentsCommand.NAME, EXPERIMENT_TYPE_CODE_GENERIC_ARG);
            if (this.getArgs().size() != 1) {
                System.err.println("Exactly one <experiment-type-code> needs to be specified.");
                this.printHelp(true);
            }
        }

        private final String getExperimentTypeCode() {
            String experimentTypeCode = StringUtils.upperCase(this.getArgs().get(0));
            try {
                return ExperimentTypeCode.getExperimentTypeCode(experimentTypeCode).getCode();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UserFailureException("Unknown experiment type code '" + experimentTypeCode + "'.");
            }
        }

        public final QueryRestriction getQueryRestriction() {
            QueryRestriction queryRestriction = super.getQueryRestriction();
            queryRestriction.setSuppressInvalidated(this.showInvalidated == null || this.showInvalidated == false);
            queryRestriction.setExperimentTypeCode(this.getExperimentTypeCode());
            return queryRestriction;
        }

        public final boolean isPrettyPrinted() {
            return this.isPrettyPrinted == null ? false : this.isPrettyPrinted;
        }
    }
}

