/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Project;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.ProjectTableModel;
import ch.systemsx.cisd.lims.client.parameters.EmptyParameters;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;
import java.util.Arrays;

public final class ListProjectsCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-projects";
    private static ListProjectsCommand instance;

    private ListProjectsCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        OutputTypeParameters parameters = new OutputTypeParameters(arguments, this.getName());
        EmptyParameters.assertArgsEmpty(parameters);
        ILIMSService limsService = this.getLIMSService(parameters);
        Object[] projects = limsService.listProjects(sessionToken);
        int len = projects.length;
        if (len == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No project have been found in the database.");
            return 0;
        }
        Arrays.sort(projects);
        ProjectTableModel model = new ProjectTableModel((Project[])projects, "Projects", parameters.isPrettyPrinted());
        this.printTable(model, parameters);
        return 0;
    }

    public static final synchronized ListProjectsCommand getInstance() {
        if (instance == null) {
            instance = new ListProjectsCommand();
        }
        return instance;
    }
}

