/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;

public final class RegisterProjectCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "register-project";
    private static RegisterProjectCommand instance;

    private RegisterProjectCommand() {
        super(NAME);
    }

    public static final synchronized RegisterProjectCommand getInstance() {
        if (instance == null) {
            instance = new RegisterProjectCommand();
        }
        return instance;
    }

    public int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        String projectCode = parameters.getProjectCode();
        limsService.registerProject(sessionToken, projectCode);
        System.out.println(String.format("New project '%s' has been successfully stored in the database.", projectCode));
        return 0;
    }

    private static final class Parameters
    extends AbstractParameters {
        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, RegisterProjectCommand.NAME, "<project-code>", exitHandler);
            if (this.getArgs().size() != 1) {
                System.err.println("There needs to be exactly one <project-code>.");
                this.printHelp(true);
            }
        }

        final String getProjectCode() {
            return this.getArgs().get(0);
        }
    }
}

